// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Vision.Face
{
    public partial class LivenessWithVerifyOutputs : IUtf8JsonSerializable, IJsonModel<LivenessWithVerifyOutputs>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<LivenessWithVerifyOutputs>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<LivenessWithVerifyOutputs>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessWithVerifyOutputs>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LivenessWithVerifyOutputs)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("verifyImage"u8);
            writer.WriteObjectValue(VerifyImage, options);
            writer.WritePropertyName("matchConfidence"u8);
            writer.WriteNumberValue(MatchConfidence);
            writer.WritePropertyName("isIdentical"u8);
            writer.WriteBooleanValue(IsIdentical);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        LivenessWithVerifyOutputs IJsonModel<LivenessWithVerifyOutputs>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessWithVerifyOutputs>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LivenessWithVerifyOutputs)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeLivenessWithVerifyOutputs(document.RootElement, options);
        }

        internal static LivenessWithVerifyOutputs DeserializeLivenessWithVerifyOutputs(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            LivenessWithVerifyImage verifyImage = default;
            float matchConfidence = default;
            bool isIdentical = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("verifyImage"u8))
                {
                    verifyImage = LivenessWithVerifyImage.DeserializeLivenessWithVerifyImage(property.Value, options);
                    continue;
                }
                if (property.NameEquals("matchConfidence"u8))
                {
                    matchConfidence = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("isIdentical"u8))
                {
                    isIdentical = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new LivenessWithVerifyOutputs(verifyImage, matchConfidence, isIdentical, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<LivenessWithVerifyOutputs>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessWithVerifyOutputs>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(LivenessWithVerifyOutputs)} does not support writing '{options.Format}' format.");
            }
        }

        LivenessWithVerifyOutputs IPersistableModel<LivenessWithVerifyOutputs>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessWithVerifyOutputs>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeLivenessWithVerifyOutputs(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(LivenessWithVerifyOutputs)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<LivenessWithVerifyOutputs>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static LivenessWithVerifyOutputs FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeLivenessWithVerifyOutputs(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
