// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Vision.Face
{
    /// <summary> The detail of face for verification. </summary>
    public partial class LivenessWithVerifyImage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LivenessWithVerifyImage"/>. </summary>
        /// <param name="faceRectangle"> The face region where the comparison image's classification was made. </param>
        /// <param name="qualityForRecognition"> Quality of face image for recognition. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="faceRectangle"/> is null. </exception>
        internal LivenessWithVerifyImage(FaceRectangle faceRectangle, QualityForRecognition qualityForRecognition)
        {
            Argument.AssertNotNull(faceRectangle, nameof(faceRectangle));

            FaceRectangle = faceRectangle;
            QualityForRecognition = qualityForRecognition;
        }

        /// <summary> Initializes a new instance of <see cref="LivenessWithVerifyImage"/>. </summary>
        /// <param name="faceRectangle"> The face region where the comparison image's classification was made. </param>
        /// <param name="qualityForRecognition"> Quality of face image for recognition. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LivenessWithVerifyImage(FaceRectangle faceRectangle, QualityForRecognition qualityForRecognition, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FaceRectangle = faceRectangle;
            QualityForRecognition = qualityForRecognition;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="LivenessWithVerifyImage"/> for deserialization. </summary>
        internal LivenessWithVerifyImage()
        {
        }

        /// <summary> The face region where the comparison image's classification was made. </summary>
        public FaceRectangle FaceRectangle { get; }
        /// <summary> Quality of face image for recognition. </summary>
        public QualityForRecognition QualityForRecognition { get; }
    }
}
