// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Vision.Face
{
    public partial class LivenessWithVerifyImage : IUtf8JsonSerializable, IJsonModel<LivenessWithVerifyImage>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<LivenessWithVerifyImage>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<LivenessWithVerifyImage>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessWithVerifyImage>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LivenessWithVerifyImage)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("faceRectangle"u8);
            writer.WriteObjectValue(FaceRectangle, options);
            writer.WritePropertyName("qualityForRecognition"u8);
            writer.WriteStringValue(QualityForRecognition.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        LivenessWithVerifyImage IJsonModel<LivenessWithVerifyImage>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessWithVerifyImage>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LivenessWithVerifyImage)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeLivenessWithVerifyImage(document.RootElement, options);
        }

        internal static LivenessWithVerifyImage DeserializeLivenessWithVerifyImage(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            FaceRectangle faceRectangle = default;
            QualityForRecognition qualityForRecognition = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("faceRectangle"u8))
                {
                    faceRectangle = FaceRectangle.DeserializeFaceRectangle(property.Value, options);
                    continue;
                }
                if (property.NameEquals("qualityForRecognition"u8))
                {
                    qualityForRecognition = new QualityForRecognition(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new LivenessWithVerifyImage(faceRectangle, qualityForRecognition, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<LivenessWithVerifyImage>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessWithVerifyImage>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(LivenessWithVerifyImage)} does not support writing '{options.Format}' format.");
            }
        }

        LivenessWithVerifyImage IPersistableModel<LivenessWithVerifyImage>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessWithVerifyImage>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeLivenessWithVerifyImage(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(LivenessWithVerifyImage)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<LivenessWithVerifyImage>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static LivenessWithVerifyImage FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeLivenessWithVerifyImage(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
