// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Vision.Face
{
    /// <summary> Session data returned for enumeration. </summary>
    public partial class LivenessSessionItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LivenessSessionItem"/>. </summary>
        /// <param name="createdDateTime"> DateTime when this session was created. </param>
        /// <param name="sessionExpired"> Whether or not the session is expired. </param>
        internal LivenessSessionItem(DateTimeOffset createdDateTime, bool sessionExpired)
        {
            CreatedDateTime = createdDateTime;
            SessionExpired = sessionExpired;
        }

        /// <summary> Initializes a new instance of <see cref="LivenessSessionItem"/>. </summary>
        /// <param name="id"> The unique ID to reference this session. </param>
        /// <param name="createdDateTime"> DateTime when this session was created. </param>
        /// <param name="sessionStartDateTime"> DateTime when this session was started by the client. </param>
        /// <param name="sessionExpired"> Whether or not the session is expired. </param>
        /// <param name="deviceCorrelationId"> Unique Guid per each end-user device. This is to provide rate limiting and anti-hammering. If 'deviceCorrelationIdSetInClient' is true in this request, this 'deviceCorrelationId' must be null. </param>
        /// <param name="authTokenTimeToLiveInSeconds"> Seconds the session should last for. Range is 60 to 86400 seconds. Default value is 600. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LivenessSessionItem(string id, DateTimeOffset createdDateTime, DateTimeOffset? sessionStartDateTime, bool sessionExpired, string deviceCorrelationId, int? authTokenTimeToLiveInSeconds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            CreatedDateTime = createdDateTime;
            SessionStartDateTime = sessionStartDateTime;
            SessionExpired = sessionExpired;
            DeviceCorrelationId = deviceCorrelationId;
            AuthTokenTimeToLiveInSeconds = authTokenTimeToLiveInSeconds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="LivenessSessionItem"/> for deserialization. </summary>
        internal LivenessSessionItem()
        {
        }

        /// <summary> The unique ID to reference this session. </summary>
        public string Id { get; }
        /// <summary> DateTime when this session was created. </summary>
        public DateTimeOffset CreatedDateTime { get; }
        /// <summary> DateTime when this session was started by the client. </summary>
        public DateTimeOffset? SessionStartDateTime { get; }
        /// <summary> Whether or not the session is expired. </summary>
        public bool SessionExpired { get; }
        /// <summary> Unique Guid per each end-user device. This is to provide rate limiting and anti-hammering. If 'deviceCorrelationIdSetInClient' is true in this request, this 'deviceCorrelationId' must be null. </summary>
        public string DeviceCorrelationId { get; }
        /// <summary> Seconds the session should last for. Range is 60 to 86400 seconds. Default value is 600. </summary>
        public int? AuthTokenTimeToLiveInSeconds { get; }
    }
}
