// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Vision.Face
{
    public partial class LivenessSessionItem : IUtf8JsonSerializable, IJsonModel<LivenessSessionItem>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<LivenessSessionItem>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<LivenessSessionItem>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessSessionItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LivenessSessionItem)} does not support writing '{format}' format.");
            }

            if (options.Format != "W")
            {
                writer.WritePropertyName("id"u8);
                writer.WriteStringValue(Id);
            }
            writer.WritePropertyName("createdDateTime"u8);
            writer.WriteStringValue(CreatedDateTime, "O");
            if (Optional.IsDefined(SessionStartDateTime))
            {
                writer.WritePropertyName("sessionStartDateTime"u8);
                writer.WriteStringValue(SessionStartDateTime.Value, "O");
            }
            writer.WritePropertyName("sessionExpired"u8);
            writer.WriteBooleanValue(SessionExpired);
            if (Optional.IsDefined(DeviceCorrelationId))
            {
                writer.WritePropertyName("deviceCorrelationId"u8);
                writer.WriteStringValue(DeviceCorrelationId);
            }
            if (Optional.IsDefined(AuthTokenTimeToLiveInSeconds))
            {
                writer.WritePropertyName("authTokenTimeToLiveInSeconds"u8);
                writer.WriteNumberValue(AuthTokenTimeToLiveInSeconds.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        LivenessSessionItem IJsonModel<LivenessSessionItem>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessSessionItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LivenessSessionItem)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeLivenessSessionItem(document.RootElement, options);
        }

        internal static LivenessSessionItem DeserializeLivenessSessionItem(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string id = default;
            DateTimeOffset createdDateTime = default;
            DateTimeOffset? sessionStartDateTime = default;
            bool sessionExpired = default;
            string deviceCorrelationId = default;
            int? authTokenTimeToLiveInSeconds = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("createdDateTime"u8))
                {
                    createdDateTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("sessionStartDateTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sessionStartDateTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("sessionExpired"u8))
                {
                    sessionExpired = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("deviceCorrelationId"u8))
                {
                    deviceCorrelationId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("authTokenTimeToLiveInSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    authTokenTimeToLiveInSeconds = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new LivenessSessionItem(
                id,
                createdDateTime,
                sessionStartDateTime,
                sessionExpired,
                deviceCorrelationId,
                authTokenTimeToLiveInSeconds,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<LivenessSessionItem>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessSessionItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(LivenessSessionItem)} does not support writing '{options.Format}' format.");
            }
        }

        LivenessSessionItem IPersistableModel<LivenessSessionItem>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessSessionItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeLivenessSessionItem(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(LivenessSessionItem)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<LivenessSessionItem>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static LivenessSessionItem FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeLivenessSessionItem(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
