// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Vision.Face
{
    /// <summary> Audit entry for a request in session. </summary>
    public partial class LivenessSessionAuditEntry
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LivenessSessionAuditEntry"/>. </summary>
        /// <param name="id"> The unique id to refer to this audit request. Use this id with the 'start' query parameter to continue on to the next page of audit results. </param>
        /// <param name="sessionId"> The unique sessionId of the created session. It will expire 48 hours after it was created or may be deleted sooner using the corresponding session DELETE operation. </param>
        /// <param name="requestId"> The unique requestId that is returned by the service to the client in the 'apim-request-id' header. </param>
        /// <param name="clientRequestId"> The unique clientRequestId that is sent by the client in the 'client-request-id' header. </param>
        /// <param name="receivedDateTime"> The UTC DateTime that the request was received. </param>
        /// <param name="request"> The request of this entry. </param>
        /// <param name="response"> The response of this entry. </param>
        /// <param name="digest"> The server calculated digest for this request. If the client reported digest differs from the server calculated digest, then the message integrity between the client and service has been compromised and the result should not be trusted. For more information, see how to guides on how to leverage this value to secure your end-to-end solution. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/>, <paramref name="requestId"/>, <paramref name="clientRequestId"/>, <paramref name="request"/>, <paramref name="response"/> or <paramref name="digest"/> is null. </exception>
        internal LivenessSessionAuditEntry(long id, string sessionId, string requestId, string clientRequestId, DateTimeOffset receivedDateTime, AuditRequestInfo request, AuditLivenessResponseInfo response, string digest)
        {
            Argument.AssertNotNull(sessionId, nameof(sessionId));
            Argument.AssertNotNull(requestId, nameof(requestId));
            Argument.AssertNotNull(clientRequestId, nameof(clientRequestId));
            Argument.AssertNotNull(request, nameof(request));
            Argument.AssertNotNull(response, nameof(response));
            Argument.AssertNotNull(digest, nameof(digest));

            Id = id;
            SessionId = sessionId;
            RequestId = requestId;
            ClientRequestId = clientRequestId;
            ReceivedDateTime = receivedDateTime;
            Request = request;
            Response = response;
            Digest = digest;
        }

        /// <summary> Initializes a new instance of <see cref="LivenessSessionAuditEntry"/>. </summary>
        /// <param name="id"> The unique id to refer to this audit request. Use this id with the 'start' query parameter to continue on to the next page of audit results. </param>
        /// <param name="sessionId"> The unique sessionId of the created session. It will expire 48 hours after it was created or may be deleted sooner using the corresponding session DELETE operation. </param>
        /// <param name="requestId"> The unique requestId that is returned by the service to the client in the 'apim-request-id' header. </param>
        /// <param name="clientRequestId"> The unique clientRequestId that is sent by the client in the 'client-request-id' header. </param>
        /// <param name="receivedDateTime"> The UTC DateTime that the request was received. </param>
        /// <param name="request"> The request of this entry. </param>
        /// <param name="response"> The response of this entry. </param>
        /// <param name="digest"> The server calculated digest for this request. If the client reported digest differs from the server calculated digest, then the message integrity between the client and service has been compromised and the result should not be trusted. For more information, see how to guides on how to leverage this value to secure your end-to-end solution. </param>
        /// <param name="sessionImageId"> The image ID of the session request. </param>
        /// <param name="verifyImageHash"> The sha256 hash of the verify-image in the request. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LivenessSessionAuditEntry(long id, string sessionId, string requestId, string clientRequestId, DateTimeOffset receivedDateTime, AuditRequestInfo request, AuditLivenessResponseInfo response, string digest, string sessionImageId, string verifyImageHash, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            SessionId = sessionId;
            RequestId = requestId;
            ClientRequestId = clientRequestId;
            ReceivedDateTime = receivedDateTime;
            Request = request;
            Response = response;
            Digest = digest;
            SessionImageId = sessionImageId;
            VerifyImageHash = verifyImageHash;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="LivenessSessionAuditEntry"/> for deserialization. </summary>
        internal LivenessSessionAuditEntry()
        {
        }

        /// <summary> The unique id to refer to this audit request. Use this id with the 'start' query parameter to continue on to the next page of audit results. </summary>
        public long Id { get; }
        /// <summary> The unique sessionId of the created session. It will expire 48 hours after it was created or may be deleted sooner using the corresponding session DELETE operation. </summary>
        public string SessionId { get; }
        /// <summary> The unique requestId that is returned by the service to the client in the 'apim-request-id' header. </summary>
        public string RequestId { get; }
        /// <summary> The unique clientRequestId that is sent by the client in the 'client-request-id' header. </summary>
        public string ClientRequestId { get; }
        /// <summary> The UTC DateTime that the request was received. </summary>
        public DateTimeOffset ReceivedDateTime { get; }
        /// <summary> The request of this entry. </summary>
        public AuditRequestInfo Request { get; }
        /// <summary> The response of this entry. </summary>
        public AuditLivenessResponseInfo Response { get; }
        /// <summary> The server calculated digest for this request. If the client reported digest differs from the server calculated digest, then the message integrity between the client and service has been compromised and the result should not be trusted. For more information, see how to guides on how to leverage this value to secure your end-to-end solution. </summary>
        public string Digest { get; }
        /// <summary> The image ID of the session request. </summary>
        public string SessionImageId { get; }
        /// <summary> The sha256 hash of the verify-image in the request. </summary>
        public string VerifyImageHash { get; }
    }
}
