// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Vision.Face
{
    public partial class LivenessSessionAuditEntry : IUtf8JsonSerializable, IJsonModel<LivenessSessionAuditEntry>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<LivenessSessionAuditEntry>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<LivenessSessionAuditEntry>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessSessionAuditEntry>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LivenessSessionAuditEntry)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("id"u8);
            writer.WriteNumberValue(Id);
            writer.WritePropertyName("sessionId"u8);
            writer.WriteStringValue(SessionId);
            writer.WritePropertyName("requestId"u8);
            writer.WriteStringValue(RequestId);
            writer.WritePropertyName("clientRequestId"u8);
            writer.WriteStringValue(ClientRequestId);
            writer.WritePropertyName("receivedDateTime"u8);
            writer.WriteStringValue(ReceivedDateTime, "O");
            writer.WritePropertyName("request"u8);
            writer.WriteObjectValue(Request, options);
            writer.WritePropertyName("response"u8);
            writer.WriteObjectValue(Response, options);
            writer.WritePropertyName("digest"u8);
            writer.WriteStringValue(Digest);
            if (Optional.IsDefined(SessionImageId))
            {
                writer.WritePropertyName("sessionImageId"u8);
                writer.WriteStringValue(SessionImageId);
            }
            if (Optional.IsDefined(VerifyImageHash))
            {
                writer.WritePropertyName("verifyImageHash"u8);
                writer.WriteStringValue(VerifyImageHash);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        LivenessSessionAuditEntry IJsonModel<LivenessSessionAuditEntry>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessSessionAuditEntry>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LivenessSessionAuditEntry)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeLivenessSessionAuditEntry(document.RootElement, options);
        }

        internal static LivenessSessionAuditEntry DeserializeLivenessSessionAuditEntry(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            long id = default;
            string sessionId = default;
            string requestId = default;
            string clientRequestId = default;
            DateTimeOffset receivedDateTime = default;
            AuditRequestInfo request = default;
            AuditLivenessResponseInfo response = default;
            string digest = default;
            string sessionImageId = default;
            string verifyImageHash = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("sessionId"u8))
                {
                    sessionId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("requestId"u8))
                {
                    requestId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("clientRequestId"u8))
                {
                    clientRequestId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("receivedDateTime"u8))
                {
                    receivedDateTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("request"u8))
                {
                    request = AuditRequestInfo.DeserializeAuditRequestInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("response"u8))
                {
                    response = AuditLivenessResponseInfo.DeserializeAuditLivenessResponseInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("digest"u8))
                {
                    digest = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sessionImageId"u8))
                {
                    sessionImageId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("verifyImageHash"u8))
                {
                    verifyImageHash = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new LivenessSessionAuditEntry(
                id,
                sessionId,
                requestId,
                clientRequestId,
                receivedDateTime,
                request,
                response,
                digest,
                sessionImageId,
                verifyImageHash,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<LivenessSessionAuditEntry>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessSessionAuditEntry>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(LivenessSessionAuditEntry)} does not support writing '{options.Format}' format.");
            }
        }

        LivenessSessionAuditEntry IPersistableModel<LivenessSessionAuditEntry>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessSessionAuditEntry>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeLivenessSessionAuditEntry(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(LivenessSessionAuditEntry)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<LivenessSessionAuditEntry>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static LivenessSessionAuditEntry FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeLivenessSessionAuditEntry(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
