// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Vision.Face
{
    /// <summary> The response body of detect liveness API call. </summary>
    public partial class LivenessResponseBody
    {
        /// <summary> Initializes a new instance of <see cref="LivenessResponseBody"/>. </summary>
        internal LivenessResponseBody()
        {
            AdditionalProperties = new ChangeTrackingDictionary<string, BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="LivenessResponseBody"/>. </summary>
        /// <param name="livenessDecision"> The liveness classification for the target face. </param>
        /// <param name="target"> Specific targets used for liveness classification. </param>
        /// <param name="modelVersionUsed"> The model version used for liveness classification. </param>
        /// <param name="verifyResult"> The face verification output. Only available when the request is liveness with verify. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal LivenessResponseBody(FaceLivenessDecision? livenessDecision, LivenessOutputsTarget target, LivenessModel? modelVersionUsed, LivenessWithVerifyOutputs verifyResult, IReadOnlyDictionary<string, BinaryData> additionalProperties)
        {
            LivenessDecision = livenessDecision;
            Target = target;
            ModelVersionUsed = modelVersionUsed;
            VerifyResult = verifyResult;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> The liveness classification for the target face. </summary>
        public FaceLivenessDecision? LivenessDecision { get; }
        /// <summary> Specific targets used for liveness classification. </summary>
        public LivenessOutputsTarget Target { get; }
        /// <summary> The model version used for liveness classification. </summary>
        public LivenessModel? ModelVersionUsed { get; }
        /// <summary> The face verification output. Only available when the request is liveness with verify. </summary>
        public LivenessWithVerifyOutputs VerifyResult { get; }
        /// <summary>
        /// Additional Properties
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IReadOnlyDictionary<string, BinaryData> AdditionalProperties { get; }
    }
}
