// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Vision.Face
{
    public partial class LivenessResponseBody : IUtf8JsonSerializable, IJsonModel<LivenessResponseBody>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<LivenessResponseBody>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<LivenessResponseBody>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessResponseBody>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LivenessResponseBody)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(LivenessDecision))
            {
                writer.WritePropertyName("livenessDecision"u8);
                writer.WriteStringValue(LivenessDecision.Value.ToString());
            }
            if (Optional.IsDefined(Target))
            {
                writer.WritePropertyName("target"u8);
                writer.WriteObjectValue(Target, options);
            }
            if (Optional.IsDefined(ModelVersionUsed))
            {
                writer.WritePropertyName("modelVersionUsed"u8);
                writer.WriteStringValue(ModelVersionUsed.Value.ToString());
            }
            if (Optional.IsDefined(VerifyResult))
            {
                writer.WritePropertyName("verifyResult"u8);
                writer.WriteObjectValue(VerifyResult, options);
            }
            foreach (var item in AdditionalProperties)
            {
                writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                using (JsonDocument document = JsonDocument.Parse(item.Value))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
        }

        LivenessResponseBody IJsonModel<LivenessResponseBody>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessResponseBody>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LivenessResponseBody)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeLivenessResponseBody(document.RootElement, options);
        }

        internal static LivenessResponseBody DeserializeLivenessResponseBody(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            FaceLivenessDecision? livenessDecision = default;
            LivenessOutputsTarget target = default;
            LivenessModel? modelVersionUsed = default;
            LivenessWithVerifyOutputs verifyResult = default;
            IReadOnlyDictionary<string, BinaryData> additionalProperties = default;
            Dictionary<string, BinaryData> additionalPropertiesDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("livenessDecision"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    livenessDecision = new FaceLivenessDecision(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("target"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    target = LivenessOutputsTarget.DeserializeLivenessOutputsTarget(property.Value, options);
                    continue;
                }
                if (property.NameEquals("modelVersionUsed"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    modelVersionUsed = new LivenessModel(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("verifyResult"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    verifyResult = LivenessWithVerifyOutputs.DeserializeLivenessWithVerifyOutputs(property.Value, options);
                    continue;
                }
                additionalPropertiesDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
            }
            additionalProperties = additionalPropertiesDictionary;
            return new LivenessResponseBody(livenessDecision, target, modelVersionUsed, verifyResult, additionalProperties);
        }

        BinaryData IPersistableModel<LivenessResponseBody>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessResponseBody>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(LivenessResponseBody)} does not support writing '{options.Format}' format.");
            }
        }

        LivenessResponseBody IPersistableModel<LivenessResponseBody>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LivenessResponseBody>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeLivenessResponseBody(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(LivenessResponseBody)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<LivenessResponseBody>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static LivenessResponseBody FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeLivenessResponseBody(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
