// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Vision.Face
{
    /// <summary> The liveness classification for target face. </summary>
    public partial class LivenessOutputsTarget
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LivenessOutputsTarget"/>. </summary>
        /// <param name="faceRectangle"> The face region where the liveness classification was made on. </param>
        /// <param name="fileName"> The file name which contains the face rectangle where the liveness classification was made on. </param>
        /// <param name="timeOffsetWithinFile"> The time offset within the file of the frame which contains the face rectangle where the liveness classification was made on. </param>
        /// <param name="imageType"> The image type which contains the face rectangle where the liveness classification was made on. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="faceRectangle"/> or <paramref name="fileName"/> is null. </exception>
        internal LivenessOutputsTarget(FaceRectangle faceRectangle, string fileName, int timeOffsetWithinFile, FaceImageType imageType)
        {
            Argument.AssertNotNull(faceRectangle, nameof(faceRectangle));
            Argument.AssertNotNull(fileName, nameof(fileName));

            FaceRectangle = faceRectangle;
            FileName = fileName;
            TimeOffsetWithinFile = timeOffsetWithinFile;
            ImageType = imageType;
        }

        /// <summary> Initializes a new instance of <see cref="LivenessOutputsTarget"/>. </summary>
        /// <param name="faceRectangle"> The face region where the liveness classification was made on. </param>
        /// <param name="fileName"> The file name which contains the face rectangle where the liveness classification was made on. </param>
        /// <param name="timeOffsetWithinFile"> The time offset within the file of the frame which contains the face rectangle where the liveness classification was made on. </param>
        /// <param name="imageType"> The image type which contains the face rectangle where the liveness classification was made on. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LivenessOutputsTarget(FaceRectangle faceRectangle, string fileName, int timeOffsetWithinFile, FaceImageType imageType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FaceRectangle = faceRectangle;
            FileName = fileName;
            TimeOffsetWithinFile = timeOffsetWithinFile;
            ImageType = imageType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="LivenessOutputsTarget"/> for deserialization. </summary>
        internal LivenessOutputsTarget()
        {
        }

        /// <summary> The face region where the liveness classification was made on. </summary>
        public FaceRectangle FaceRectangle { get; }
        /// <summary> The file name which contains the face rectangle where the liveness classification was made on. </summary>
        public string FileName { get; }
        /// <summary> The time offset within the file of the frame which contains the face rectangle where the liveness classification was made on. </summary>
        public int TimeOffsetWithinFile { get; }
        /// <summary> The image type which contains the face rectangle where the liveness classification was made on. </summary>
        public FaceImageType ImageType { get; }
    }
}
