// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Vision.Face
{
    /// <summary> The model version used for liveness classification. </summary>
    public readonly partial struct LivenessModel : IEquatable<LivenessModel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LivenessModel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LivenessModel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string V20221015Preview04Value = "2022-10-15-preview.04";
        private const string V20231220Preview06Value = "2023-12-20-preview.06";

        /// <summary> 2022-10-15-preview.04. </summary>
        public static LivenessModel V20221015Preview04 { get; } = new LivenessModel(V20221015Preview04Value);
        /// <summary> 2023-12-20-preview.06. </summary>
        public static LivenessModel V20231220Preview06 { get; } = new LivenessModel(V20231220Preview06Value);
        /// <summary> Determines if two <see cref="LivenessModel"/> values are the same. </summary>
        public static bool operator ==(LivenessModel left, LivenessModel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LivenessModel"/> values are not the same. </summary>
        public static bool operator !=(LivenessModel left, LivenessModel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LivenessModel"/>. </summary>
        public static implicit operator LivenessModel(string value) => new LivenessModel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LivenessModel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LivenessModel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
