// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.AI.Vision.Face
{
    // Data plane generated sub-client.
    /// <summary> The LargePersonGroup sub-client. </summary>
    public partial class LargePersonGroupClient
    {
        private const string AuthorizationHeader = "Ocp-Apim-Subscription-Key";
        private readonly AzureKeyCredential _keyCredential;
        private static readonly string[] AuthorizationScopes = new string[] { "https://cognitiveservices.azure.com/.default" };
        private readonly TokenCredential _tokenCredential;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _largePersonGroupId;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> The HTTP pipeline for sending and receiving REST requests and responses. </summary>
        public virtual HttpPipeline Pipeline => _pipeline;

        /// <summary> Initializes a new instance of LargePersonGroupClient for mocking. </summary>
        protected LargePersonGroupClient()
        {
        }

        /// <summary> Initializes a new instance of LargePersonGroupClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="keyCredential"> The key credential to copy. </param>
        /// <param name="tokenCredential"> The token credential to copy. </param>
        /// <param name="endpoint">
        /// Supported Cognitive Services endpoints (protocol and hostname, for example:
        /// https://{resource-name}.cognitiveservices.azure.com).
        /// </param>
        /// <param name="largePersonGroupId"> ID of the container. </param>
        /// <param name="apiVersion"> API Version. Allowed values: "v1.1-preview.1" | "v1.2-preview.1". </param>
        internal LargePersonGroupClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, AzureKeyCredential keyCredential, TokenCredential tokenCredential, Uri endpoint, string largePersonGroupId, string apiVersion)
        {
            ClientDiagnostics = clientDiagnostics;
            _pipeline = pipeline;
            _keyCredential = keyCredential;
            _tokenCredential = tokenCredential;
            _endpoint = endpoint;
            _largePersonGroupId = largePersonGroupId;
            _apiVersion = apiVersion;
        }

        /// <summary> Create a new Large Person Group with user-specified largePersonGroupId, name, an optional userData and recognitionModel. </summary>
        /// <param name="name"> User defined name, maximum length is 128. </param>
        /// <param name="userData"> Optional user defined data. Length should not exceed 16K. </param>
        /// <param name="recognitionModel"> The 'recognitionModel' associated with this face list. Supported 'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and 'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and 'recognition_02'. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/create-large-person-group for more details. </remarks>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='CreateAsync(string,string,FaceRecognitionModel?,CancellationToken)']/*" />
        public virtual async Task<Response> CreateAsync(string name, string userData = null, FaceRecognitionModel? recognitionModel = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(name, nameof(name));

            CreateRequest createRequest = new CreateRequest(name, userData, recognitionModel, null);
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await CreateAsync(createRequest.ToRequestContent(), context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Create a new Large Person Group with user-specified largePersonGroupId, name, an optional userData and recognitionModel. </summary>
        /// <param name="name"> User defined name, maximum length is 128. </param>
        /// <param name="userData"> Optional user defined data. Length should not exceed 16K. </param>
        /// <param name="recognitionModel"> The 'recognitionModel' associated with this face list. Supported 'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and 'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and 'recognition_02'. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/create-large-person-group for more details. </remarks>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='Create(string,string,FaceRecognitionModel?,CancellationToken)']/*" />
        public virtual Response Create(string name, string userData = null, FaceRecognitionModel? recognitionModel = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(name, nameof(name));

            CreateRequest createRequest = new CreateRequest(name, userData, recognitionModel, null);
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = Create(createRequest.ToRequestContent(), context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Create a new Large Person Group with user-specified largePersonGroupId, name, an optional userData and recognitionModel.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateAsync(string,string,FaceRecognitionModel?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='CreateAsync(RequestContent,RequestContext)']/*" />
        public virtual async Task<Response> CreateAsync(RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.Create");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateRequest(content, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Create a new Large Person Group with user-specified largePersonGroupId, name, an optional userData and recognitionModel.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="Create(string,string,FaceRecognitionModel?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='Create(RequestContent,RequestContext)']/*" />
        public virtual Response Create(RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.Create");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateRequest(content, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/delete-large-person-group for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='DeleteAsync(RequestContext)']/*" />
        public virtual async Task<Response> DeleteAsync(RequestContext context = null)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.Delete");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteRequest(context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/delete-large-person-group for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='Delete(RequestContext)']/*" />
        public virtual Response Delete(RequestContext context = null)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.Delete");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteRequest(context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group for more details. </summary>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetLargePersonGroupAsync(bool?,CancellationToken)']/*" />
        public virtual async Task<Response<LargePersonGroup>> GetLargePersonGroupAsync(bool? returnRecognitionModel = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetLargePersonGroupAsync(returnRecognitionModel, context).ConfigureAwait(false);
            return Response.FromValue(LargePersonGroup.FromResponse(response), response);
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group for more details. </summary>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetLargePersonGroup(bool?,CancellationToken)']/*" />
        public virtual Response<LargePersonGroup> GetLargePersonGroup(bool? returnRecognitionModel = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetLargePersonGroup(returnRecognitionModel, context);
            return Response.FromValue(LargePersonGroup.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLargePersonGroupAsync(bool?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetLargePersonGroupAsync(bool?,RequestContext)']/*" />
        public virtual async Task<Response> GetLargePersonGroupAsync(bool? returnRecognitionModel, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.GetLargePersonGroup");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLargePersonGroupRequest(returnRecognitionModel, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLargePersonGroup(bool?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetLargePersonGroup(bool?,RequestContext)']/*" />
        public virtual Response GetLargePersonGroup(bool? returnRecognitionModel, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.GetLargePersonGroup");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLargePersonGroupRequest(returnRecognitionModel, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='UpdateAsync(RequestContent,RequestContext)']/*" />
        public virtual async Task<Response> UpdateAsync(RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.Update");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdateRequest(content, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='Update(RequestContent,RequestContext)']/*" />
        public virtual Response Update(RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.Update");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdateRequest(content, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> List all existing Large Person Groups' largePersonGroupId, name, userData and recognitionModel. </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-groups for more details. </remarks>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetLargePersonGroupsAsync(string,int?,bool?,CancellationToken)']/*" />
        public virtual async Task<Response<IReadOnlyList<LargePersonGroup>>> GetLargePersonGroupsAsync(string start = null, int? top = null, bool? returnRecognitionModel = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetLargePersonGroupsAsync(start, top, returnRecognitionModel, context).ConfigureAwait(false);
            IReadOnlyList<LargePersonGroup> value = default;
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            List<LargePersonGroup> array = new List<LargePersonGroup>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LargePersonGroup.DeserializeLargePersonGroup(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary> List all existing Large Person Groups' largePersonGroupId, name, userData and recognitionModel. </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-groups for more details. </remarks>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetLargePersonGroups(string,int?,bool?,CancellationToken)']/*" />
        public virtual Response<IReadOnlyList<LargePersonGroup>> GetLargePersonGroups(string start = null, int? top = null, bool? returnRecognitionModel = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetLargePersonGroups(start, top, returnRecognitionModel, context);
            IReadOnlyList<LargePersonGroup> value = default;
            using var document = JsonDocument.Parse(response.ContentStream);
            List<LargePersonGroup> array = new List<LargePersonGroup>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LargePersonGroup.DeserializeLargePersonGroup(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary>
        /// [Protocol Method] List all existing Large Person Groups' largePersonGroupId, name, userData and recognitionModel.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLargePersonGroupsAsync(string,int?,bool?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetLargePersonGroupsAsync(string,int?,bool?,RequestContext)']/*" />
        public virtual async Task<Response> GetLargePersonGroupsAsync(string start, int? top, bool? returnRecognitionModel, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.GetLargePersonGroups");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLargePersonGroupsRequest(start, top, returnRecognitionModel, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] List all existing Large Person Groups' largePersonGroupId, name, userData and recognitionModel.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLargePersonGroups(string,int?,bool?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetLargePersonGroups(string,int?,bool?,RequestContext)']/*" />
        public virtual Response GetLargePersonGroups(string start, int? top, bool? returnRecognitionModel, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.GetLargePersonGroups");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLargePersonGroupsRequest(start, top, returnRecognitionModel, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> To check Large Person Group training status completed or still ongoing. Large Person Group training is an asynchronous operation triggered by "Train Large Person Group" API. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-training-status for more details. </remarks>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetTrainingStatusAsync(CancellationToken)']/*" />
        public virtual async Task<Response<FaceTrainingResult>> GetTrainingStatusAsync(CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetTrainingStatusAsync(context).ConfigureAwait(false);
            return Response.FromValue(FaceTrainingResult.FromResponse(response), response);
        }

        /// <summary> To check Large Person Group training status completed or still ongoing. Large Person Group training is an asynchronous operation triggered by "Train Large Person Group" API. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-training-status for more details. </remarks>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetTrainingStatus(CancellationToken)']/*" />
        public virtual Response<FaceTrainingResult> GetTrainingStatus(CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetTrainingStatus(context);
            return Response.FromValue(FaceTrainingResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] To check Large Person Group training status completed or still ongoing. Large Person Group training is an asynchronous operation triggered by "Train Large Person Group" API.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetTrainingStatusAsync(CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetTrainingStatusAsync(RequestContext)']/*" />
        public virtual async Task<Response> GetTrainingStatusAsync(RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.GetTrainingStatus");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetTrainingStatusRequest(context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] To check Large Person Group training status completed or still ongoing. Large Person Group training is an asynchronous operation triggered by "Train Large Person Group" API.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetTrainingStatus(CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetTrainingStatus(RequestContext)']/*" />
        public virtual Response GetTrainingStatus(RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.GetTrainingStatus");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetTrainingStatusRequest(context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Create a new person in a specified Large Person Group. To add face to this person, please call "Add Large Person Group Person Face". </summary>
        /// <param name="name"> User defined name, maximum length is 128. </param>
        /// <param name="userData"> Optional user defined data. Length should not exceed 16K. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/create-large-person-group-person for more details. </remarks>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='CreatePersonAsync(string,string,CancellationToken)']/*" />
        public virtual async Task<Response<CreatePersonResult>> CreatePersonAsync(string name, string userData = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(name, nameof(name));

            CreatePersonRequest createPersonRequest = new CreatePersonRequest(name, userData, null);
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await CreatePersonAsync(createPersonRequest.ToRequestContent(), context).ConfigureAwait(false);
            return Response.FromValue(CreatePersonResult.FromResponse(response), response);
        }

        /// <summary> Create a new person in a specified Large Person Group. To add face to this person, please call "Add Large Person Group Person Face". </summary>
        /// <param name="name"> User defined name, maximum length is 128. </param>
        /// <param name="userData"> Optional user defined data. Length should not exceed 16K. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/create-large-person-group-person for more details. </remarks>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='CreatePerson(string,string,CancellationToken)']/*" />
        public virtual Response<CreatePersonResult> CreatePerson(string name, string userData = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(name, nameof(name));

            CreatePersonRequest createPersonRequest = new CreatePersonRequest(name, userData, null);
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = CreatePerson(createPersonRequest.ToRequestContent(), context);
            return Response.FromValue(CreatePersonResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Create a new person in a specified Large Person Group. To add face to this person, please call "Add Large Person Group Person Face".
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreatePersonAsync(string,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='CreatePersonAsync(RequestContent,RequestContext)']/*" />
        public virtual async Task<Response> CreatePersonAsync(RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.CreatePerson");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreatePersonRequest(content, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Create a new person in a specified Large Person Group. To add face to this person, please call "Add Large Person Group Person Face".
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreatePerson(string,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='CreatePerson(RequestContent,RequestContext)']/*" />
        public virtual Response CreatePerson(RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.CreatePerson");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreatePersonRequest(content, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/delete-large-person-group-person for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='DeletePersonAsync(Guid,RequestContext)']/*" />
        public virtual async Task<Response> DeletePersonAsync(Guid personId, RequestContext context = null)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.DeletePerson");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeletePersonRequest(personId, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/delete-large-person-group-person for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='DeletePerson(Guid,RequestContext)']/*" />
        public virtual Response DeletePerson(Guid personId, RequestContext context = null)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.DeletePerson");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeletePersonRequest(personId, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-person for more details. </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetPersonAsync(Guid,CancellationToken)']/*" />
        public virtual async Task<Response<LargePersonGroupPerson>> GetPersonAsync(Guid personId, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetPersonAsync(personId, context).ConfigureAwait(false);
            return Response.FromValue(LargePersonGroupPerson.FromResponse(response), response);
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-person for more details. </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetPerson(Guid,CancellationToken)']/*" />
        public virtual Response<LargePersonGroupPerson> GetPerson(Guid personId, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetPerson(personId, context);
            return Response.FromValue(LargePersonGroupPerson.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-person for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetPersonAsync(Guid,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetPersonAsync(Guid,RequestContext)']/*" />
        public virtual async Task<Response> GetPersonAsync(Guid personId, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.GetPerson");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetPersonRequest(personId, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-person for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetPerson(Guid,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetPerson(Guid,RequestContext)']/*" />
        public virtual Response GetPerson(Guid personId, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.GetPerson");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetPersonRequest(personId, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group-person for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='UpdatePersonAsync(Guid,RequestContent,RequestContext)']/*" />
        public virtual async Task<Response> UpdatePersonAsync(Guid personId, RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.UpdatePerson");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdatePersonRequest(personId, content, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group-person for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='UpdatePerson(Guid,RequestContent,RequestContext)']/*" />
        public virtual Response UpdatePerson(Guid personId, RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.UpdatePerson");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdatePersonRequest(personId, content, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> List all persons' information in the specified Large Person Group, including personId, name, userData and persistedFaceIds of registered person faces. </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-persons for more details. </remarks>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetPersonsAsync(string,int?,CancellationToken)']/*" />
        public virtual async Task<Response<IReadOnlyList<LargePersonGroupPerson>>> GetPersonsAsync(string start = null, int? top = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetPersonsAsync(start, top, context).ConfigureAwait(false);
            IReadOnlyList<LargePersonGroupPerson> value = default;
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            List<LargePersonGroupPerson> array = new List<LargePersonGroupPerson>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LargePersonGroupPerson.DeserializeLargePersonGroupPerson(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary> List all persons' information in the specified Large Person Group, including personId, name, userData and persistedFaceIds of registered person faces. </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-persons for more details. </remarks>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetPersons(string,int?,CancellationToken)']/*" />
        public virtual Response<IReadOnlyList<LargePersonGroupPerson>> GetPersons(string start = null, int? top = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetPersons(start, top, context);
            IReadOnlyList<LargePersonGroupPerson> value = default;
            using var document = JsonDocument.Parse(response.ContentStream);
            List<LargePersonGroupPerson> array = new List<LargePersonGroupPerson>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LargePersonGroupPerson.DeserializeLargePersonGroupPerson(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary>
        /// [Protocol Method] List all persons' information in the specified Large Person Group, including personId, name, userData and persistedFaceIds of registered person faces.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetPersonsAsync(string,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetPersonsAsync(string,int?,RequestContext)']/*" />
        public virtual async Task<Response> GetPersonsAsync(string start, int? top, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.GetPersons");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetPersonsRequest(start, top, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] List all persons' information in the specified Large Person Group, including personId, name, userData and persistedFaceIds of registered person faces.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetPersons(string,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetPersons(string,int?,RequestContext)']/*" />
        public virtual Response GetPersons(string start, int? top, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.GetPersons");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetPersonsRequest(start, top, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Add a face to a person into a Large Person Group for face identification or verification. </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="uri"> URL of input image. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="uri"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/add-large-person-group-person-face-from-url for more details. </remarks>
        internal virtual async Task<Response<AddFaceResult>> AddFaceFromUrlImplAsync(Guid personId, Uri uri, IEnumerable<int> targetFace = null, FaceDetectionModel? detectionModel = null, string userData = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(uri, nameof(uri));

            AddFaceFromUrlRequest addFaceFromUrlRequest = new AddFaceFromUrlRequest(uri, null);
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await AddFaceFromUrlImplAsync(personId, addFaceFromUrlRequest.ToRequestContent(), targetFace, detectionModel?.ToString(), userData, context).ConfigureAwait(false);
            return Response.FromValue(AddFaceResult.FromResponse(response), response);
        }

        /// <summary> Add a face to a person into a Large Person Group for face identification or verification. </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="uri"> URL of input image. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="uri"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/add-large-person-group-person-face-from-url for more details. </remarks>
        internal virtual Response<AddFaceResult> AddFaceFromUrlImpl(Guid personId, Uri uri, IEnumerable<int> targetFace = null, FaceDetectionModel? detectionModel = null, string userData = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(uri, nameof(uri));

            AddFaceFromUrlRequest addFaceFromUrlRequest = new AddFaceFromUrlRequest(uri, null);
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = AddFaceFromUrlImpl(personId, addFaceFromUrlRequest.ToRequestContent(), targetFace, detectionModel?.ToString(), userData, context);
            return Response.FromValue(AddFaceResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Add a face to a person into a Large Person Group for face identification or verification.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="AddFaceFromUrlImplAsync(Guid,Uri,IEnumerable{int},FaceDetectionModel?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. Allowed values: "detection_01" | "detection_02" | "detection_03". </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual async Task<Response> AddFaceFromUrlImplAsync(Guid personId, RequestContent content, IEnumerable<int> targetFace = null, string detectionModel = null, string userData = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.AddFaceFromUrlImpl");
            scope.Start();
            try
            {
                using HttpMessage message = CreateAddFaceFromUrlImplRequest(personId, content, targetFace, detectionModel, userData, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Add a face to a person into a Large Person Group for face identification or verification.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="AddFaceFromUrlImpl(Guid,Uri,IEnumerable{int},FaceDetectionModel?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. Allowed values: "detection_01" | "detection_02" | "detection_03". </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual Response AddFaceFromUrlImpl(Guid personId, RequestContent content, IEnumerable<int> targetFace = null, string detectionModel = null, string userData = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.AddFaceFromUrlImpl");
            scope.Start();
            try
            {
                using HttpMessage message = CreateAddFaceFromUrlImplRequest(personId, content, targetFace, detectionModel, userData, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Add a face to a person into a Large Person Group for face identification or verification. </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="imageContent"> The image to be analyzed. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="imageContent"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/add-large-person-group-person-face for more details. </remarks>
        internal virtual async Task<Response<AddFaceResult>> AddFaceImplAsync(Guid personId, BinaryData imageContent, IEnumerable<int> targetFace = null, FaceDetectionModel? detectionModel = null, string userData = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(imageContent, nameof(imageContent));

            using RequestContent content = imageContent;
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await AddFaceImplAsync(personId, content, targetFace, detectionModel?.ToString(), userData, context).ConfigureAwait(false);
            return Response.FromValue(AddFaceResult.FromResponse(response), response);
        }

        /// <summary> Add a face to a person into a Large Person Group for face identification or verification. </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="imageContent"> The image to be analyzed. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="imageContent"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/add-large-person-group-person-face for more details. </remarks>
        internal virtual Response<AddFaceResult> AddFaceImpl(Guid personId, BinaryData imageContent, IEnumerable<int> targetFace = null, FaceDetectionModel? detectionModel = null, string userData = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(imageContent, nameof(imageContent));

            using RequestContent content = imageContent;
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = AddFaceImpl(personId, content, targetFace, detectionModel?.ToString(), userData, context);
            return Response.FromValue(AddFaceResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Add a face to a person into a Large Person Group for face identification or verification.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="AddFaceImplAsync(Guid,BinaryData,IEnumerable{int},FaceDetectionModel?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. Allowed values: "detection_01" | "detection_02" | "detection_03". </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual async Task<Response> AddFaceImplAsync(Guid personId, RequestContent content, IEnumerable<int> targetFace = null, string detectionModel = null, string userData = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.AddFaceImpl");
            scope.Start();
            try
            {
                using HttpMessage message = CreateAddFaceImplRequest(personId, content, targetFace, detectionModel, userData, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Add a face to a person into a Large Person Group for face identification or verification.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="AddFaceImpl(Guid,BinaryData,IEnumerable{int},FaceDetectionModel?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. Allowed values: "detection_01" | "detection_02" | "detection_03". </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual Response AddFaceImpl(Guid personId, RequestContent content, IEnumerable<int> targetFace = null, string detectionModel = null, string userData = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.AddFaceImpl");
            scope.Start();
            try
            {
                using HttpMessage message = CreateAddFaceImplRequest(personId, content, targetFace, detectionModel, userData, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Delete a face from a person in a Large Person Group by specified largePersonGroupId, personId and persistedFaceId.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='DeleteFaceAsync(Guid,Guid,RequestContext)']/*" />
        public virtual async Task<Response> DeleteFaceAsync(Guid personId, Guid persistedFaceId, RequestContext context = null)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.DeleteFace");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteFaceRequest(personId, persistedFaceId, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Delete a face from a person in a Large Person Group by specified largePersonGroupId, personId and persistedFaceId.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='DeleteFace(Guid,Guid,RequestContext)']/*" />
        public virtual Response DeleteFace(Guid personId, Guid persistedFaceId, RequestContext context = null)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.DeleteFace");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteFaceRequest(personId, persistedFaceId, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-person-face for more details. </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetFaceAsync(Guid,Guid,CancellationToken)']/*" />
        public virtual async Task<Response<LargePersonGroupPersonFace>> GetFaceAsync(Guid personId, Guid persistedFaceId, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetFaceAsync(personId, persistedFaceId, context).ConfigureAwait(false);
            return Response.FromValue(LargePersonGroupPersonFace.FromResponse(response), response);
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-person-face for more details. </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetFace(Guid,Guid,CancellationToken)']/*" />
        public virtual Response<LargePersonGroupPersonFace> GetFace(Guid personId, Guid persistedFaceId, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetFace(personId, persistedFaceId, context);
            return Response.FromValue(LargePersonGroupPersonFace.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-person-face for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetFaceAsync(Guid,Guid,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetFaceAsync(Guid,Guid,RequestContext)']/*" />
        public virtual async Task<Response> GetFaceAsync(Guid personId, Guid persistedFaceId, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.GetFace");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetFaceRequest(personId, persistedFaceId, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/get-large-person-group-person-face for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetFace(Guid,Guid,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='GetFace(Guid,Guid,RequestContext)']/*" />
        public virtual Response GetFace(Guid personId, Guid persistedFaceId, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.GetFace");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetFaceRequest(personId, persistedFaceId, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group-person-face for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='UpdateFaceAsync(Guid,Guid,RequestContent,RequestContext)']/*" />
        public virtual async Task<Response> UpdateFaceAsync(Guid personId, Guid persistedFaceId, RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.UpdateFace");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdateFaceRequest(personId, persistedFaceId, content, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/person-group-operations/update-large-person-group-person-face for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='UpdateFace(Guid,Guid,RequestContent,RequestContext)']/*" />
        public virtual Response UpdateFace(Guid personId, Guid persistedFaceId, RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.UpdateFace");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdateFaceRequest(personId, persistedFaceId, content, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Submit a Large Person Group training task. Training is a crucial step that only a trained Large Person Group can be used by "Identify From Large Person Group".
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Operation"/> representing an asynchronous operation on the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='TrainAsync(WaitUntil,RequestContext)']/*" />
        public virtual async Task<Operation> TrainAsync(WaitUntil waitUntil, RequestContext context = null)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.Train");
            scope.Start();
            try
            {
                using HttpMessage message = CreateTrainRequest(context);
                return await ProtocolOperationHelpers.ProcessMessageWithoutResponseValueAsync(_pipeline, message, ClientDiagnostics, "LargePersonGroupClient.Train", OperationFinalStateVia.OperationLocation, context, waitUntil).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Submit a Large Person Group training task. Training is a crucial step that only a trained Large Person Group can be used by "Identify From Large Person Group".
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Operation"/> representing an asynchronous operation on the service. </returns>
        /// <include file="Docs/LargePersonGroupClient.xml" path="doc/members/member[@name='Train(WaitUntil,RequestContext)']/*" />
        public virtual Operation Train(WaitUntil waitUntil, RequestContext context = null)
        {
            using var scope = ClientDiagnostics.CreateScope("LargePersonGroupClient.Train");
            scope.Start();
            try
            {
                using HttpMessage message = CreateTrainRequest(context);
                return ProtocolOperationHelpers.ProcessMessageWithoutResponseValue(_pipeline, message, ClientDiagnostics, "LargePersonGroupClient.Train", OperationFinalStateVia.OperationLocation, context, waitUntil);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        internal HttpMessage CreateCreateRequest(RequestContent content, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateDeleteRequest(RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetLargePersonGroupRequest(bool? returnRecognitionModel, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            if (returnRecognitionModel != null)
            {
                uri.AppendQuery("returnRecognitionModel", returnRecognitionModel.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateUpdateRequest(RequestContent content, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateGetLargePersonGroupsRequest(string start, int? top, bool? returnRecognitionModel, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups", false);
            if (start != null)
            {
                uri.AppendQuery("start", start, true);
            }
            if (top != null)
            {
                uri.AppendQuery("top", top.Value, true);
            }
            if (returnRecognitionModel != null)
            {
                uri.AppendQuery("returnRecognitionModel", returnRecognitionModel.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetTrainingStatusRequest(RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            uri.AppendPath("/training", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateTrainRequest(RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier202);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            uri.AppendPath("/train", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateCreatePersonRequest(RequestContent content, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            uri.AppendPath("/persons", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateDeletePersonRequest(Guid personId, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            uri.AppendPath("/persons/", false);
            uri.AppendPath(personId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetPersonRequest(Guid personId, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            uri.AppendPath("/persons/", false);
            uri.AppendPath(personId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateUpdatePersonRequest(Guid personId, RequestContent content, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            uri.AppendPath("/persons/", false);
            uri.AppendPath(personId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateGetPersonsRequest(string start, int? top, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            uri.AppendPath("/persons", false);
            if (start != null)
            {
                uri.AppendQuery("start", start, true);
            }
            if (top != null)
            {
                uri.AppendQuery("top", top.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateAddFaceFromUrlImplRequest(Guid personId, RequestContent content, IEnumerable<int> targetFace, string detectionModel, string userData, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            uri.AppendPath("/persons/", false);
            uri.AppendPath(personId, true);
            uri.AppendPath("/persistedfaces", false);
            if (targetFace != null && !(targetFace is ChangeTrackingList<int> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("targetFace", targetFace, ",", true);
            }
            if (detectionModel != null)
            {
                uri.AppendQuery("detectionModel", detectionModel, true);
            }
            if (userData != null)
            {
                uri.AppendQuery("userData", userData, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateAddFaceImplRequest(Guid personId, RequestContent content, IEnumerable<int> targetFace, string detectionModel, string userData, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            uri.AppendPath("/persons/", false);
            uri.AppendPath(personId, true);
            uri.AppendPath("/persistedfaces", false);
            if (targetFace != null && !(targetFace is ChangeTrackingList<int> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("targetFace", targetFace, ",", true);
            }
            if (detectionModel != null)
            {
                uri.AppendQuery("detectionModel", detectionModel, true);
            }
            if (userData != null)
            {
                uri.AppendQuery("userData", userData, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/octet-stream");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateDeleteFaceRequest(Guid personId, Guid persistedFaceId, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            uri.AppendPath("/persons/", false);
            uri.AppendPath(personId, true);
            uri.AppendPath("/persistedfaces/", false);
            uri.AppendPath(persistedFaceId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetFaceRequest(Guid personId, Guid persistedFaceId, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            uri.AppendPath("/persons/", false);
            uri.AppendPath(personId, true);
            uri.AppendPath("/persistedfaces/", false);
            uri.AppendPath(persistedFaceId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateUpdateFaceRequest(Guid personId, Guid persistedFaceId, RequestContent content, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largepersongroups/", false);
            uri.AppendPath(_largePersonGroupId, true);
            uri.AppendPath("/persons/", false);
            uri.AppendPath(personId, true);
            uri.AppendPath("/persistedfaces/", false);
            uri.AppendPath(persistedFaceId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            request.Content = content;
            return message;
        }

        private static RequestContext DefaultRequestContext = new RequestContext();
        internal static RequestContext FromCancellationToken(CancellationToken cancellationToken = default)
        {
            if (!cancellationToken.CanBeCanceled)
            {
                return DefaultRequestContext;
            }

            return new RequestContext() { CancellationToken = cancellationToken };
        }

        private static ResponseClassifier _responseClassifier200;
        private static ResponseClassifier ResponseClassifier200 => _responseClassifier200 ??= new StatusCodeClassifier(stackalloc ushort[] { 200 });
        private static ResponseClassifier _responseClassifier202;
        private static ResponseClassifier ResponseClassifier202 => _responseClassifier202 ??= new StatusCodeClassifier(stackalloc ushort[] { 202 });
    }
}
