// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.AI.Vision.Face
{
    // Data plane generated sub-client.
    /// <summary> The LargeFaceList sub-client. </summary>
    public partial class LargeFaceListClient
    {
        private const string AuthorizationHeader = "Ocp-Apim-Subscription-Key";
        private readonly AzureKeyCredential _keyCredential;
        private static readonly string[] AuthorizationScopes = new string[] { "https://cognitiveservices.azure.com/.default" };
        private readonly TokenCredential _tokenCredential;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _largeFaceListId;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> The HTTP pipeline for sending and receiving REST requests and responses. </summary>
        public virtual HttpPipeline Pipeline => _pipeline;

        /// <summary> Initializes a new instance of LargeFaceListClient for mocking. </summary>
        protected LargeFaceListClient()
        {
        }

        /// <summary> Initializes a new instance of LargeFaceListClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="keyCredential"> The key credential to copy. </param>
        /// <param name="tokenCredential"> The token credential to copy. </param>
        /// <param name="endpoint">
        /// Supported Cognitive Services endpoints (protocol and hostname, for example:
        /// https://{resource-name}.cognitiveservices.azure.com).
        /// </param>
        /// <param name="largeFaceListId"> Valid character is letter in lower case or digit or '-' or '_', maximum length is 64. </param>
        /// <param name="apiVersion"> API Version. Allowed values: "v1.1-preview.1" | "v1.2-preview.1". </param>
        internal LargeFaceListClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, AzureKeyCredential keyCredential, TokenCredential tokenCredential, Uri endpoint, string largeFaceListId, string apiVersion)
        {
            ClientDiagnostics = clientDiagnostics;
            _pipeline = pipeline;
            _keyCredential = keyCredential;
            _tokenCredential = tokenCredential;
            _endpoint = endpoint;
            _largeFaceListId = largeFaceListId;
            _apiVersion = apiVersion;
        }

        /// <summary> Create an empty Large Face List with user-specified largeFaceListId, name, an optional userData and recognitionModel. </summary>
        /// <param name="name"> User defined name, maximum length is 128. </param>
        /// <param name="userData"> Optional user defined data. Length should not exceed 16K. </param>
        /// <param name="recognitionModel"> The 'recognitionModel' associated with this face list. Supported 'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and 'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and 'recognition_02'. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/create-large-face-list for more details. </remarks>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='CreateAsync(string,string,FaceRecognitionModel?,CancellationToken)']/*" />
        public virtual async Task<Response> CreateAsync(string name, string userData = null, FaceRecognitionModel? recognitionModel = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(name, nameof(name));

            CreateRequest1 createRequest1 = new CreateRequest1(name, userData, recognitionModel, null);
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await CreateAsync(createRequest1.ToRequestContent(), context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Create an empty Large Face List with user-specified largeFaceListId, name, an optional userData and recognitionModel. </summary>
        /// <param name="name"> User defined name, maximum length is 128. </param>
        /// <param name="userData"> Optional user defined data. Length should not exceed 16K. </param>
        /// <param name="recognitionModel"> The 'recognitionModel' associated with this face list. Supported 'recognitionModel' values include 'recognition_01', 'recognition_02, 'recognition_03', and 'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and 'recognition_02'. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/create-large-face-list for more details. </remarks>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='Create(string,string,FaceRecognitionModel?,CancellationToken)']/*" />
        public virtual Response Create(string name, string userData = null, FaceRecognitionModel? recognitionModel = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(name, nameof(name));

            CreateRequest1 createRequest1 = new CreateRequest1(name, userData, recognitionModel, null);
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = Create(createRequest1.ToRequestContent(), context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Create an empty Large Face List with user-specified largeFaceListId, name, an optional userData and recognitionModel.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateAsync(string,string,FaceRecognitionModel?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='CreateAsync(RequestContent,RequestContext)']/*" />
        public virtual async Task<Response> CreateAsync(RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.Create");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateRequest(content, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Create an empty Large Face List with user-specified largeFaceListId, name, an optional userData and recognitionModel.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="Create(string,string,FaceRecognitionModel?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='Create(RequestContent,RequestContext)']/*" />
        public virtual Response Create(RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.Create");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateRequest(content, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Delete a face from a Large Face List by specified largeFaceListId and persistedFaceId.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='DeleteAsync(RequestContext)']/*" />
        public virtual async Task<Response> DeleteAsync(RequestContext context = null)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.Delete");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteRequest(context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Delete a face from a Large Face List by specified largeFaceListId and persistedFaceId.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='Delete(RequestContext)']/*" />
        public virtual Response Delete(RequestContext context = null)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.Delete");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteRequest(context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list for more details. </summary>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetLargeFaceListAsync(bool?,CancellationToken)']/*" />
        public virtual async Task<Response<LargeFaceList>> GetLargeFaceListAsync(bool? returnRecognitionModel = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetLargeFaceListAsync(returnRecognitionModel, context).ConfigureAwait(false);
            return Response.FromValue(LargeFaceList.FromResponse(response), response);
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list for more details. </summary>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetLargeFaceList(bool?,CancellationToken)']/*" />
        public virtual Response<LargeFaceList> GetLargeFaceList(bool? returnRecognitionModel = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetLargeFaceList(returnRecognitionModel, context);
            return Response.FromValue(LargeFaceList.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLargeFaceListAsync(bool?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetLargeFaceListAsync(bool?,RequestContext)']/*" />
        public virtual async Task<Response> GetLargeFaceListAsync(bool? returnRecognitionModel, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.GetLargeFaceList");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLargeFaceListRequest(returnRecognitionModel, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLargeFaceList(bool?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetLargeFaceList(bool?,RequestContext)']/*" />
        public virtual Response GetLargeFaceList(bool? returnRecognitionModel, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.GetLargeFaceList");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLargeFaceListRequest(returnRecognitionModel, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/update-large-face-list for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='UpdateAsync(RequestContent,RequestContext)']/*" />
        public virtual async Task<Response> UpdateAsync(RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.Update");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdateRequest(content, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/update-large-face-list for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='Update(RequestContent,RequestContext)']/*" />
        public virtual Response Update(RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.Update");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdateRequest(content, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> List Large Face Lists' information of largeFaceListId, name, userData and recognitionModel. </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-lists for more details. </remarks>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetLargeFaceListsAsync(string,int?,bool?,CancellationToken)']/*" />
        public virtual async Task<Response<IReadOnlyList<LargeFaceList>>> GetLargeFaceListsAsync(string start = null, int? top = null, bool? returnRecognitionModel = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetLargeFaceListsAsync(start, top, returnRecognitionModel, context).ConfigureAwait(false);
            IReadOnlyList<LargeFaceList> value = default;
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            List<LargeFaceList> array = new List<LargeFaceList>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LargeFaceList.DeserializeLargeFaceList(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary> List Large Face Lists' information of largeFaceListId, name, userData and recognitionModel. </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-lists for more details. </remarks>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetLargeFaceLists(string,int?,bool?,CancellationToken)']/*" />
        public virtual Response<IReadOnlyList<LargeFaceList>> GetLargeFaceLists(string start = null, int? top = null, bool? returnRecognitionModel = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetLargeFaceLists(start, top, returnRecognitionModel, context);
            IReadOnlyList<LargeFaceList> value = default;
            using var document = JsonDocument.Parse(response.ContentStream);
            List<LargeFaceList> array = new List<LargeFaceList>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LargeFaceList.DeserializeLargeFaceList(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary>
        /// [Protocol Method] List Large Face Lists' information of largeFaceListId, name, userData and recognitionModel.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLargeFaceListsAsync(string,int?,bool?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetLargeFaceListsAsync(string,int?,bool?,RequestContext)']/*" />
        public virtual async Task<Response> GetLargeFaceListsAsync(string start, int? top, bool? returnRecognitionModel, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.GetLargeFaceLists");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLargeFaceListsRequest(start, top, returnRecognitionModel, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] List Large Face Lists' information of largeFaceListId, name, userData and recognitionModel.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLargeFaceLists(string,int?,bool?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetLargeFaceLists(string,int?,bool?,RequestContext)']/*" />
        public virtual Response GetLargeFaceLists(string start, int? top, bool? returnRecognitionModel, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.GetLargeFaceLists");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLargeFaceListsRequest(start, top, returnRecognitionModel, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list-training-status for more details. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetTrainingStatusAsync(CancellationToken)']/*" />
        public virtual async Task<Response<FaceTrainingResult>> GetTrainingStatusAsync(CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetTrainingStatusAsync(context).ConfigureAwait(false);
            return Response.FromValue(FaceTrainingResult.FromResponse(response), response);
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list-training-status for more details. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetTrainingStatus(CancellationToken)']/*" />
        public virtual Response<FaceTrainingResult> GetTrainingStatus(CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetTrainingStatus(context);
            return Response.FromValue(FaceTrainingResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list-training-status for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetTrainingStatusAsync(CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetTrainingStatusAsync(RequestContext)']/*" />
        public virtual async Task<Response> GetTrainingStatusAsync(RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.GetTrainingStatus");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetTrainingStatusRequest(context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list-training-status for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetTrainingStatus(CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetTrainingStatus(RequestContext)']/*" />
        public virtual Response GetTrainingStatus(RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.GetTrainingStatus");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetTrainingStatusRequest(context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Add a face to a specified Large Face List, up to 1,000,000 faces. </summary>
        /// <param name="uri"> URL of input image. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="uri"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/add-large-face-list-face-from-url for more details. </remarks>
        internal virtual async Task<Response<AddFaceResult>> AddFaceFromUrlImplAsync(Uri uri, IEnumerable<int> targetFace = null, FaceDetectionModel? detectionModel = null, string userData = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(uri, nameof(uri));

            AddFaceFromUrlRequest1 addFaceFromUrlRequest1 = new AddFaceFromUrlRequest1(uri, null);
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await AddFaceFromUrlImplAsync(addFaceFromUrlRequest1.ToRequestContent(), targetFace, detectionModel?.ToString(), userData, context).ConfigureAwait(false);
            return Response.FromValue(AddFaceResult.FromResponse(response), response);
        }

        /// <summary> Add a face to a specified Large Face List, up to 1,000,000 faces. </summary>
        /// <param name="uri"> URL of input image. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="uri"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/add-large-face-list-face-from-url for more details. </remarks>
        internal virtual Response<AddFaceResult> AddFaceFromUrlImpl(Uri uri, IEnumerable<int> targetFace = null, FaceDetectionModel? detectionModel = null, string userData = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(uri, nameof(uri));

            AddFaceFromUrlRequest1 addFaceFromUrlRequest1 = new AddFaceFromUrlRequest1(uri, null);
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = AddFaceFromUrlImpl(addFaceFromUrlRequest1.ToRequestContent(), targetFace, detectionModel?.ToString(), userData, context);
            return Response.FromValue(AddFaceResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Add a face to a specified Large Face List, up to 1,000,000 faces.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="AddFaceFromUrlImplAsync(Uri,IEnumerable{int},FaceDetectionModel?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. Allowed values: "detection_01" | "detection_02" | "detection_03". </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual async Task<Response> AddFaceFromUrlImplAsync(RequestContent content, IEnumerable<int> targetFace = null, string detectionModel = null, string userData = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.AddFaceFromUrlImpl");
            scope.Start();
            try
            {
                using HttpMessage message = CreateAddFaceFromUrlImplRequest(content, targetFace, detectionModel, userData, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Add a face to a specified Large Face List, up to 1,000,000 faces.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="AddFaceFromUrlImpl(Uri,IEnumerable{int},FaceDetectionModel?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. Allowed values: "detection_01" | "detection_02" | "detection_03". </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual Response AddFaceFromUrlImpl(RequestContent content, IEnumerable<int> targetFace = null, string detectionModel = null, string userData = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.AddFaceFromUrlImpl");
            scope.Start();
            try
            {
                using HttpMessage message = CreateAddFaceFromUrlImplRequest(content, targetFace, detectionModel, userData, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Add a face to a specified Large Face List, up to 1,000,000 faces. </summary>
        /// <param name="imageContent"> The image to be analyzed. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="imageContent"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/add-large-face-list-face for more details. </remarks>
        internal virtual async Task<Response<AddFaceResult>> AddFaceImplAsync(BinaryData imageContent, IEnumerable<int> targetFace = null, FaceDetectionModel? detectionModel = null, string userData = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(imageContent, nameof(imageContent));

            using RequestContent content = imageContent;
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await AddFaceImplAsync(content, targetFace, detectionModel?.ToString(), userData, context).ConfigureAwait(false);
            return Response.FromValue(AddFaceResult.FromResponse(response), response);
        }

        /// <summary> Add a face to a specified Large Face List, up to 1,000,000 faces. </summary>
        /// <param name="imageContent"> The image to be analyzed. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="imageContent"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/add-large-face-list-face for more details. </remarks>
        internal virtual Response<AddFaceResult> AddFaceImpl(BinaryData imageContent, IEnumerable<int> targetFace = null, FaceDetectionModel? detectionModel = null, string userData = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(imageContent, nameof(imageContent));

            using RequestContent content = imageContent;
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = AddFaceImpl(content, targetFace, detectionModel?.ToString(), userData, context);
            return Response.FromValue(AddFaceResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Add a face to a specified Large Face List, up to 1,000,000 faces.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="AddFaceImplAsync(BinaryData,IEnumerable{int},FaceDetectionModel?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. Allowed values: "detection_01" | "detection_02" | "detection_03". </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual async Task<Response> AddFaceImplAsync(RequestContent content, IEnumerable<int> targetFace = null, string detectionModel = null, string userData = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.AddFaceImpl");
            scope.Start();
            try
            {
                using HttpMessage message = CreateAddFaceImplRequest(content, targetFace, detectionModel, userData, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Add a face to a specified Large Face List, up to 1,000,000 faces.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="AddFaceImpl(BinaryData,IEnumerable{int},FaceDetectionModel?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="targetFace"> A face rectangle to specify the target face to be added to a person, in the format of 'targetFace=left,top,width,height'. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. Allowed values: "detection_01" | "detection_02" | "detection_03". </param>
        /// <param name="userData"> User-provided data attached to the face. The size limit is 1K. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual Response AddFaceImpl(RequestContent content, IEnumerable<int> targetFace = null, string detectionModel = null, string userData = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.AddFaceImpl");
            scope.Start();
            try
            {
                using HttpMessage message = CreateAddFaceImplRequest(content, targetFace, detectionModel, userData, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/delete-large-face-list-face for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='DeleteFaceAsync(Guid,RequestContext)']/*" />
        public virtual async Task<Response> DeleteFaceAsync(Guid persistedFaceId, RequestContext context = null)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.DeleteFace");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteFaceRequest(persistedFaceId, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/delete-large-face-list-face for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='DeleteFace(Guid,RequestContext)']/*" />
        public virtual Response DeleteFace(Guid persistedFaceId, RequestContext context = null)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.DeleteFace");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteFaceRequest(persistedFaceId, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list-face for more details. </summary>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetFaceAsync(Guid,CancellationToken)']/*" />
        public virtual async Task<Response<LargeFaceListFace>> GetFaceAsync(Guid persistedFaceId, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetFaceAsync(persistedFaceId, context).ConfigureAwait(false);
            return Response.FromValue(LargeFaceListFace.FromResponse(response), response);
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list-face for more details. </summary>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetFace(Guid,CancellationToken)']/*" />
        public virtual Response<LargeFaceListFace> GetFace(Guid persistedFaceId, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetFace(persistedFaceId, context);
            return Response.FromValue(LargeFaceListFace.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list-face for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetFaceAsync(Guid,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetFaceAsync(Guid,RequestContext)']/*" />
        public virtual async Task<Response> GetFaceAsync(Guid persistedFaceId, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.GetFace");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetFaceRequest(persistedFaceId, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list-face for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetFace(Guid,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetFace(Guid,RequestContext)']/*" />
        public virtual Response GetFace(Guid persistedFaceId, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.GetFace");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetFaceRequest(persistedFaceId, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/update-large-face-list-face for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='UpdateFaceAsync(Guid,RequestContent,RequestContext)']/*" />
        public virtual async Task<Response> UpdateFaceAsync(Guid persistedFaceId, RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.UpdateFace");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdateFaceRequest(persistedFaceId, content, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/update-large-face-list-face for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='UpdateFace(Guid,RequestContent,RequestContext)']/*" />
        public virtual Response UpdateFace(Guid persistedFaceId, RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.UpdateFace");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdateFaceRequest(persistedFaceId, content, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> List faces' persistedFaceId and userData in a specified Large Face List. </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list-faces for more details. </remarks>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetFacesAsync(string,int?,CancellationToken)']/*" />
        public virtual async Task<Response<IReadOnlyList<LargeFaceListFace>>> GetFacesAsync(string start = null, int? top = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetFacesAsync(start, top, context).ConfigureAwait(false);
            IReadOnlyList<LargeFaceListFace> value = default;
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            List<LargeFaceListFace> array = new List<LargeFaceListFace>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LargeFaceListFace.DeserializeLargeFaceListFace(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary> List faces' persistedFaceId and userData in a specified Large Face List. </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/face-list-operations/get-large-face-list-faces for more details. </remarks>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetFaces(string,int?,CancellationToken)']/*" />
        public virtual Response<IReadOnlyList<LargeFaceListFace>> GetFaces(string start = null, int? top = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetFaces(start, top, context);
            IReadOnlyList<LargeFaceListFace> value = default;
            using var document = JsonDocument.Parse(response.ContentStream);
            List<LargeFaceListFace> array = new List<LargeFaceListFace>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LargeFaceListFace.DeserializeLargeFaceListFace(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary>
        /// [Protocol Method] List faces' persistedFaceId and userData in a specified Large Face List.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetFacesAsync(string,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetFacesAsync(string,int?,RequestContext)']/*" />
        public virtual async Task<Response> GetFacesAsync(string start, int? top, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.GetFaces");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetFacesRequest(start, top, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] List faces' persistedFaceId and userData in a specified Large Face List.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetFaces(string,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='GetFaces(string,int?,RequestContext)']/*" />
        public virtual Response GetFaces(string start, int? top, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.GetFaces");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetFacesRequest(start, top, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Submit a Large Face List training task.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Operation"/> representing an asynchronous operation on the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='TrainAsync(WaitUntil,RequestContext)']/*" />
        public virtual async Task<Operation> TrainAsync(WaitUntil waitUntil, RequestContext context = null)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.Train");
            scope.Start();
            try
            {
                using HttpMessage message = CreateTrainRequest(context);
                return await ProtocolOperationHelpers.ProcessMessageWithoutResponseValueAsync(_pipeline, message, ClientDiagnostics, "LargeFaceListClient.Train", OperationFinalStateVia.OperationLocation, context, waitUntil).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Submit a Large Face List training task.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Operation"/> representing an asynchronous operation on the service. </returns>
        /// <include file="Docs/LargeFaceListClient.xml" path="doc/members/member[@name='Train(WaitUntil,RequestContext)']/*" />
        public virtual Operation Train(WaitUntil waitUntil, RequestContext context = null)
        {
            using var scope = ClientDiagnostics.CreateScope("LargeFaceListClient.Train");
            scope.Start();
            try
            {
                using HttpMessage message = CreateTrainRequest(context);
                return ProtocolOperationHelpers.ProcessMessageWithoutResponseValue(_pipeline, message, ClientDiagnostics, "LargeFaceListClient.Train", OperationFinalStateVia.OperationLocation, context, waitUntil);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        internal HttpMessage CreateCreateRequest(RequestContent content, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largefacelists/", false);
            uri.AppendPath(_largeFaceListId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateDeleteRequest(RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largefacelists/", false);
            uri.AppendPath(_largeFaceListId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetLargeFaceListRequest(bool? returnRecognitionModel, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largefacelists/", false);
            uri.AppendPath(_largeFaceListId, true);
            if (returnRecognitionModel != null)
            {
                uri.AppendQuery("returnRecognitionModel", returnRecognitionModel.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateUpdateRequest(RequestContent content, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largefacelists/", false);
            uri.AppendPath(_largeFaceListId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateGetLargeFaceListsRequest(string start, int? top, bool? returnRecognitionModel, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largefacelists", false);
            if (start != null)
            {
                uri.AppendQuery("start", start, true);
            }
            if (top != null)
            {
                uri.AppendQuery("top", top.Value, true);
            }
            if (returnRecognitionModel != null)
            {
                uri.AppendQuery("returnRecognitionModel", returnRecognitionModel.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetTrainingStatusRequest(RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largefacelists/", false);
            uri.AppendPath(_largeFaceListId, true);
            uri.AppendPath("/training", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateTrainRequest(RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier202);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largefacelists/", false);
            uri.AppendPath(_largeFaceListId, true);
            uri.AppendPath("/train", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateAddFaceFromUrlImplRequest(RequestContent content, IEnumerable<int> targetFace, string detectionModel, string userData, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largefacelists/", false);
            uri.AppendPath(_largeFaceListId, true);
            uri.AppendPath("/persistedfaces", false);
            if (targetFace != null && !(targetFace is ChangeTrackingList<int> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("targetFace", targetFace, ",", true);
            }
            if (detectionModel != null)
            {
                uri.AppendQuery("detectionModel", detectionModel, true);
            }
            if (userData != null)
            {
                uri.AppendQuery("userData", userData, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateAddFaceImplRequest(RequestContent content, IEnumerable<int> targetFace, string detectionModel, string userData, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largefacelists/", false);
            uri.AppendPath(_largeFaceListId, true);
            uri.AppendPath("/persistedfaces", false);
            if (targetFace != null && !(targetFace is ChangeTrackingList<int> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("targetFace", targetFace, ",", true);
            }
            if (detectionModel != null)
            {
                uri.AppendQuery("detectionModel", detectionModel, true);
            }
            if (userData != null)
            {
                uri.AppendQuery("userData", userData, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/octet-stream");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateDeleteFaceRequest(Guid persistedFaceId, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largefacelists/", false);
            uri.AppendPath(_largeFaceListId, true);
            uri.AppendPath("/persistedfaces/", false);
            uri.AppendPath(persistedFaceId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetFaceRequest(Guid persistedFaceId, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largefacelists/", false);
            uri.AppendPath(_largeFaceListId, true);
            uri.AppendPath("/persistedfaces/", false);
            uri.AppendPath(persistedFaceId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateUpdateFaceRequest(Guid persistedFaceId, RequestContent content, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largefacelists/", false);
            uri.AppendPath(_largeFaceListId, true);
            uri.AppendPath("/persistedfaces/", false);
            uri.AppendPath(persistedFaceId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateGetFacesRequest(string start, int? top, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/largefacelists/", false);
            uri.AppendPath(_largeFaceListId, true);
            uri.AppendPath("/persistedfaces", false);
            if (start != null)
            {
                uri.AppendQuery("start", start, true);
            }
            if (top != null)
            {
                uri.AppendQuery("top", top.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        private static RequestContext DefaultRequestContext = new RequestContext();
        internal static RequestContext FromCancellationToken(CancellationToken cancellationToken = default)
        {
            if (!cancellationToken.CanBeCanceled)
            {
                return DefaultRequestContext;
            }

            return new RequestContext() { CancellationToken = cancellationToken };
        }

        private static ResponseClassifier _responseClassifier200;
        private static ResponseClassifier ResponseClassifier200 => _responseClassifier200 ??= new StatusCodeClassifier(stackalloc ushort[] { 200 });
        private static ResponseClassifier _responseClassifier202;
        private static ResponseClassifier ResponseClassifier202 => _responseClassifier202 ??= new StatusCodeClassifier(stackalloc ushort[] { 202 });
    }
}
