// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Vision.Face
{
    internal partial class IdentifyFromLargePersonGroupRequest : IUtf8JsonSerializable, IJsonModel<IdentifyFromLargePersonGroupRequest>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<IdentifyFromLargePersonGroupRequest>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<IdentifyFromLargePersonGroupRequest>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IdentifyFromLargePersonGroupRequest>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IdentifyFromLargePersonGroupRequest)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("faceIds"u8);
            writer.WriteStartArray();
            foreach (var item in FaceIds)
            {
                writer.WriteStringValue(item);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("largePersonGroupId"u8);
            writer.WriteStringValue(LargePersonGroupId);
            if (Optional.IsDefined(MaxNumOfCandidatesReturned))
            {
                writer.WritePropertyName("maxNumOfCandidatesReturned"u8);
                writer.WriteNumberValue(MaxNumOfCandidatesReturned.Value);
            }
            if (Optional.IsDefined(ConfidenceThreshold))
            {
                writer.WritePropertyName("confidenceThreshold"u8);
                writer.WriteNumberValue(ConfidenceThreshold.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        IdentifyFromLargePersonGroupRequest IJsonModel<IdentifyFromLargePersonGroupRequest>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IdentifyFromLargePersonGroupRequest>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IdentifyFromLargePersonGroupRequest)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeIdentifyFromLargePersonGroupRequest(document.RootElement, options);
        }

        internal static IdentifyFromLargePersonGroupRequest DeserializeIdentifyFromLargePersonGroupRequest(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<Guid> faceIds = default;
            string largePersonGroupId = default;
            int? maxNumOfCandidatesReturned = default;
            float? confidenceThreshold = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("faceIds"u8))
                {
                    List<Guid> array = new List<Guid>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetGuid());
                    }
                    faceIds = array;
                    continue;
                }
                if (property.NameEquals("largePersonGroupId"u8))
                {
                    largePersonGroupId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("maxNumOfCandidatesReturned"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxNumOfCandidatesReturned = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("confidenceThreshold"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    confidenceThreshold = property.Value.GetSingle();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new IdentifyFromLargePersonGroupRequest(faceIds, largePersonGroupId, maxNumOfCandidatesReturned, confidenceThreshold, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<IdentifyFromLargePersonGroupRequest>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IdentifyFromLargePersonGroupRequest>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(IdentifyFromLargePersonGroupRequest)} does not support writing '{options.Format}' format.");
            }
        }

        IdentifyFromLargePersonGroupRequest IPersistableModel<IdentifyFromLargePersonGroupRequest>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IdentifyFromLargePersonGroupRequest>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeIdentifyFromLargePersonGroupRequest(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(IdentifyFromLargePersonGroupRequest)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<IdentifyFromLargePersonGroupRequest>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static IdentifyFromLargePersonGroupRequest FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeIdentifyFromLargePersonGroupRequest(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
