// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Vision.Face
{
    /// <summary> Glasses type of the face. </summary>
    public readonly partial struct GlassesType : IEquatable<GlassesType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GlassesType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GlassesType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoGlassesValue = "noGlasses";
        private const string ReadingGlassesValue = "readingGlasses";
        private const string SunglassesValue = "sunglasses";
        private const string SwimmingGogglesValue = "swimmingGoggles";

        /// <summary> No glasses on the face. </summary>
        public static GlassesType NoGlasses { get; } = new GlassesType(NoGlassesValue);
        /// <summary> Normal glasses on the face. </summary>
        public static GlassesType ReadingGlasses { get; } = new GlassesType(ReadingGlassesValue);
        /// <summary> Sunglasses on the face. </summary>
        public static GlassesType Sunglasses { get; } = new GlassesType(SunglassesValue);
        /// <summary> Swimming goggles on the face. </summary>
        public static GlassesType SwimmingGoggles { get; } = new GlassesType(SwimmingGogglesValue);
        /// <summary> Determines if two <see cref="GlassesType"/> values are the same. </summary>
        public static bool operator ==(GlassesType left, GlassesType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GlassesType"/> values are not the same. </summary>
        public static bool operator !=(GlassesType left, GlassesType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GlassesType"/>. </summary>
        public static implicit operator GlassesType(string value) => new GlassesType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GlassesType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GlassesType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
