// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.Vision.Face
{
    /// <summary> The FindSimilarRequest. </summary>
    internal partial class FindSimilarRequest
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FindSimilarRequest"/>. </summary>
        /// <param name="faceId"> faceId of the query face. User needs to call "Detect" first to get a valid faceId. Note that this faceId is not persisted and will expire 24 hours after the detection call. </param>
        /// <param name="faceIds"> An array of candidate faceIds. All of them are created by "Detect" and the faceIds will expire 24 hours after the detection call. The number of faceIds is limited to 1000. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="faceIds"/> is null. </exception>
        internal FindSimilarRequest(Guid faceId, IEnumerable<Guid> faceIds)
        {
            Argument.AssertNotNull(faceIds, nameof(faceIds));

            FaceId = faceId;
            FaceIds = faceIds.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="FindSimilarRequest"/>. </summary>
        /// <param name="faceId"> faceId of the query face. User needs to call "Detect" first to get a valid faceId. Note that this faceId is not persisted and will expire 24 hours after the detection call. </param>
        /// <param name="maxNumOfCandidatesReturned"> The number of top similar faces returned. The valid range is [1, 1000]. Default value is 20. </param>
        /// <param name="mode"> Similar face searching mode. It can be 'matchPerson' or 'matchFace'. Default value is 'matchPerson'. </param>
        /// <param name="faceIds"> An array of candidate faceIds. All of them are created by "Detect" and the faceIds will expire 24 hours after the detection call. The number of faceIds is limited to 1000. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FindSimilarRequest(Guid faceId, int? maxNumOfCandidatesReturned, FindSimilarMatchMode? mode, IReadOnlyList<Guid> faceIds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FaceId = faceId;
            MaxNumOfCandidatesReturned = maxNumOfCandidatesReturned;
            Mode = mode;
            FaceIds = faceIds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FindSimilarRequest"/> for deserialization. </summary>
        internal FindSimilarRequest()
        {
        }

        /// <summary> faceId of the query face. User needs to call "Detect" first to get a valid faceId. Note that this faceId is not persisted and will expire 24 hours after the detection call. </summary>
        public Guid FaceId { get; }
        /// <summary> The number of top similar faces returned. The valid range is [1, 1000]. Default value is 20. </summary>
        public int? MaxNumOfCandidatesReturned { get; }
        /// <summary> Similar face searching mode. It can be 'matchPerson' or 'matchFace'. Default value is 'matchPerson'. </summary>
        public FindSimilarMatchMode? Mode { get; }
        /// <summary> An array of candidate faceIds. All of them are created by "Detect" and the faceIds will expire 24 hours after the detection call. The number of faceIds is limited to 1000. </summary>
        public IReadOnlyList<Guid> FaceIds { get; }
    }
}
