// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Vision.Face
{
    internal partial class FindSimilarFromLargeFaceListRequest : IUtf8JsonSerializable, IJsonModel<FindSimilarFromLargeFaceListRequest>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FindSimilarFromLargeFaceListRequest>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FindSimilarFromLargeFaceListRequest>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FindSimilarFromLargeFaceListRequest>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FindSimilarFromLargeFaceListRequest)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("faceId"u8);
            writer.WriteStringValue(FaceId);
            if (Optional.IsDefined(MaxNumOfCandidatesReturned))
            {
                writer.WritePropertyName("maxNumOfCandidatesReturned"u8);
                writer.WriteNumberValue(MaxNumOfCandidatesReturned.Value);
            }
            if (Optional.IsDefined(Mode))
            {
                writer.WritePropertyName("mode"u8);
                writer.WriteStringValue(Mode.Value.ToString());
            }
            writer.WritePropertyName("largeFaceListId"u8);
            writer.WriteStringValue(LargeFaceListId);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FindSimilarFromLargeFaceListRequest IJsonModel<FindSimilarFromLargeFaceListRequest>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FindSimilarFromLargeFaceListRequest>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FindSimilarFromLargeFaceListRequest)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFindSimilarFromLargeFaceListRequest(document.RootElement, options);
        }

        internal static FindSimilarFromLargeFaceListRequest DeserializeFindSimilarFromLargeFaceListRequest(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Guid faceId = default;
            int? maxNumOfCandidatesReturned = default;
            FindSimilarMatchMode? mode = default;
            string largeFaceListId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("faceId"u8))
                {
                    faceId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("maxNumOfCandidatesReturned"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxNumOfCandidatesReturned = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("mode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    mode = new FindSimilarMatchMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("largeFaceListId"u8))
                {
                    largeFaceListId = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FindSimilarFromLargeFaceListRequest(faceId, maxNumOfCandidatesReturned, mode, largeFaceListId, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<FindSimilarFromLargeFaceListRequest>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FindSimilarFromLargeFaceListRequest>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FindSimilarFromLargeFaceListRequest)} does not support writing '{options.Format}' format.");
            }
        }

        FindSimilarFromLargeFaceListRequest IPersistableModel<FindSimilarFromLargeFaceListRequest>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FindSimilarFromLargeFaceListRequest>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFindSimilarFromLargeFaceListRequest(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FindSimilarFromLargeFaceListRequest)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FindSimilarFromLargeFaceListRequest>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static FindSimilarFromLargeFaceListRequest FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeFindSimilarFromLargeFaceListRequest(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
