// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Vision.Face
{
    /// <summary> Training result of a container. </summary>
    public partial class FaceTrainingResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FaceTrainingResult"/>. </summary>
        /// <param name="status"> Training status of the container. </param>
        /// <param name="createdDateTime"> A combined UTC date and time string that describes the created time of the person group, large person group or large face list. </param>
        /// <param name="lastActionDateTime"> A combined UTC date and time string that describes the last modify time of the person group, large person group or large face list, could be null value when the group is not successfully trained. </param>
        /// <param name="lastSuccessfulTrainingDateTime"> A combined UTC date and time string that describes the last successful training time of the person group, large person group or large face list. </param>
        internal FaceTrainingResult(FaceOperationStatus status, DateTimeOffset createdDateTime, DateTimeOffset lastActionDateTime, DateTimeOffset lastSuccessfulTrainingDateTime)
        {
            Status = status;
            CreatedDateTime = createdDateTime;
            LastActionDateTime = lastActionDateTime;
            LastSuccessfulTrainingDateTime = lastSuccessfulTrainingDateTime;
        }

        /// <summary> Initializes a new instance of <see cref="FaceTrainingResult"/>. </summary>
        /// <param name="status"> Training status of the container. </param>
        /// <param name="createdDateTime"> A combined UTC date and time string that describes the created time of the person group, large person group or large face list. </param>
        /// <param name="lastActionDateTime"> A combined UTC date and time string that describes the last modify time of the person group, large person group or large face list, could be null value when the group is not successfully trained. </param>
        /// <param name="lastSuccessfulTrainingDateTime"> A combined UTC date and time string that describes the last successful training time of the person group, large person group or large face list. </param>
        /// <param name="message"> Show failure message when training failed (omitted when training succeed). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FaceTrainingResult(FaceOperationStatus status, DateTimeOffset createdDateTime, DateTimeOffset lastActionDateTime, DateTimeOffset lastSuccessfulTrainingDateTime, string message, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            CreatedDateTime = createdDateTime;
            LastActionDateTime = lastActionDateTime;
            LastSuccessfulTrainingDateTime = lastSuccessfulTrainingDateTime;
            Message = message;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FaceTrainingResult"/> for deserialization. </summary>
        internal FaceTrainingResult()
        {
        }

        /// <summary> Training status of the container. </summary>
        public FaceOperationStatus Status { get; }
        /// <summary> A combined UTC date and time string that describes the created time of the person group, large person group or large face list. </summary>
        public DateTimeOffset CreatedDateTime { get; }
        /// <summary> A combined UTC date and time string that describes the last modify time of the person group, large person group or large face list, could be null value when the group is not successfully trained. </summary>
        public DateTimeOffset LastActionDateTime { get; }
        /// <summary> A combined UTC date and time string that describes the last successful training time of the person group, large person group or large face list. </summary>
        public DateTimeOffset LastSuccessfulTrainingDateTime { get; }
        /// <summary> Show failure message when training failed (omitted when training succeed). </summary>
        public string Message { get; }
    }
}
