// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.AI.Vision.Face
{
    // Data plane generated client.
    /// <summary> The FaceSession service client. </summary>
    public partial class FaceSessionClient
    {
        private const string AuthorizationHeader = "Ocp-Apim-Subscription-Key";
        private readonly AzureKeyCredential _keyCredential;
        private static readonly string[] AuthorizationScopes = new string[] { "https://cognitiveservices.azure.com/.default" };
        private readonly TokenCredential _tokenCredential;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> The HTTP pipeline for sending and receiving REST requests and responses. </summary>
        public virtual HttpPipeline Pipeline => _pipeline;

        /// <summary> Initializes a new instance of FaceSessionClient for mocking. </summary>
        protected FaceSessionClient()
        {
        }

        /// <summary> Initializes a new instance of FaceSessionClient. </summary>
        /// <param name="endpoint">
        /// Supported Cognitive Services endpoints (protocol and hostname, for example:
        /// https://{resource-name}.cognitiveservices.azure.com).
        /// </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="credential"/> is null. </exception>
        public FaceSessionClient(Uri endpoint, AzureKeyCredential credential) : this(endpoint, credential, new AzureAIVisionFaceClientOptions())
        {
        }

        /// <summary> Initializes a new instance of FaceSessionClient. </summary>
        /// <param name="endpoint">
        /// Supported Cognitive Services endpoints (protocol and hostname, for example:
        /// https://{resource-name}.cognitiveservices.azure.com).
        /// </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="credential"/> is null. </exception>
        public FaceSessionClient(Uri endpoint, TokenCredential credential) : this(endpoint, credential, new AzureAIVisionFaceClientOptions())
        {
        }

        /// <summary> Initializes a new instance of FaceSessionClient. </summary>
        /// <param name="endpoint">
        /// Supported Cognitive Services endpoints (protocol and hostname, for example:
        /// https://{resource-name}.cognitiveservices.azure.com).
        /// </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <param name="options"> The options for configuring the client. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="credential"/> is null. </exception>
        public FaceSessionClient(Uri endpoint, AzureKeyCredential credential, AzureAIVisionFaceClientOptions options)
        {
            Argument.AssertNotNull(endpoint, nameof(endpoint));
            Argument.AssertNotNull(credential, nameof(credential));
            options ??= new AzureAIVisionFaceClientOptions();

            ClientDiagnostics = new ClientDiagnostics(options, true);
            _keyCredential = credential;
            _pipeline = HttpPipelineBuilder.Build(options, Array.Empty<HttpPipelinePolicy>(), new HttpPipelinePolicy[] { new AzureKeyCredentialPolicy(_keyCredential, AuthorizationHeader) }, new ResponseClassifier());
            _endpoint = endpoint;
            _apiVersion = options.Version;
        }

        /// <summary> Initializes a new instance of FaceSessionClient. </summary>
        /// <param name="endpoint">
        /// Supported Cognitive Services endpoints (protocol and hostname, for example:
        /// https://{resource-name}.cognitiveservices.azure.com).
        /// </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <param name="options"> The options for configuring the client. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="credential"/> is null. </exception>
        public FaceSessionClient(Uri endpoint, TokenCredential credential, AzureAIVisionFaceClientOptions options)
        {
            Argument.AssertNotNull(endpoint, nameof(endpoint));
            Argument.AssertNotNull(credential, nameof(credential));
            options ??= new AzureAIVisionFaceClientOptions();

            ClientDiagnostics = new ClientDiagnostics(options, true);
            _tokenCredential = credential;
            _pipeline = HttpPipelineBuilder.Build(options, Array.Empty<HttpPipelinePolicy>(), new HttpPipelinePolicy[] { new BearerTokenAuthenticationPolicy(_tokenCredential, AuthorizationScopes) }, new ResponseClassifier());
            _endpoint = endpoint;
            _apiVersion = options.Version;
        }

        /// <summary> Create a new detect liveness session. </summary>
        /// <param name="body"> Body parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/create-liveness-session for more details. </remarks>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='CreateLivenessSessionAsync(CreateLivenessSessionContent,CancellationToken)']/*" />
        public virtual async Task<Response<CreateLivenessSessionResult>> CreateLivenessSessionAsync(CreateLivenessSessionContent body, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(body, nameof(body));

            using RequestContent content = body.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await CreateLivenessSessionAsync(content, context).ConfigureAwait(false);
            return Response.FromValue(CreateLivenessSessionResult.FromResponse(response), response);
        }

        /// <summary> Create a new detect liveness session. </summary>
        /// <param name="body"> Body parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/create-liveness-session for more details. </remarks>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='CreateLivenessSession(CreateLivenessSessionContent,CancellationToken)']/*" />
        public virtual Response<CreateLivenessSessionResult> CreateLivenessSession(CreateLivenessSessionContent body, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(body, nameof(body));

            using RequestContent content = body.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = CreateLivenessSession(content, context);
            return Response.FromValue(CreateLivenessSessionResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Create a new detect liveness session.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateLivenessSessionAsync(CreateLivenessSessionContent,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='CreateLivenessSessionAsync(RequestContent,RequestContext)']/*" />
        public virtual async Task<Response> CreateLivenessSessionAsync(RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.CreateLivenessSession");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateLivenessSessionRequest(content, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Create a new detect liveness session.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateLivenessSession(CreateLivenessSessionContent,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='CreateLivenessSession(RequestContent,RequestContext)']/*" />
        public virtual Response CreateLivenessSession(RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.CreateLivenessSession");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateLivenessSessionRequest(content, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Delete all session related information for matching the specified session id.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='DeleteLivenessSessionAsync(string,RequestContext)']/*" />
        public virtual async Task<Response> DeleteLivenessSessionAsync(string sessionId, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.DeleteLivenessSession");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteLivenessSessionRequest(sessionId, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Delete all session related information for matching the specified session id.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='DeleteLivenessSession(string,RequestContext)']/*" />
        public virtual Response DeleteLivenessSession(string sessionId, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.DeleteLivenessSession");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteLivenessSessionRequest(sessionId, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-session-result for more details. </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessSessionResultAsync(string,CancellationToken)']/*" />
        public virtual async Task<Response<LivenessSession>> GetLivenessSessionResultAsync(string sessionId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetLivenessSessionResultAsync(sessionId, context).ConfigureAwait(false);
            return Response.FromValue(LivenessSession.FromResponse(response), response);
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-session-result for more details. </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessSessionResult(string,CancellationToken)']/*" />
        public virtual Response<LivenessSession> GetLivenessSessionResult(string sessionId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetLivenessSessionResult(sessionId, context);
            return Response.FromValue(LivenessSession.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-session-result for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLivenessSessionResultAsync(string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessSessionResultAsync(string,RequestContext)']/*" />
        public virtual async Task<Response> GetLivenessSessionResultAsync(string sessionId, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.GetLivenessSessionResult");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLivenessSessionResultRequest(sessionId, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-session-result for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLivenessSessionResult(string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessSessionResult(string,RequestContext)']/*" />
        public virtual Response GetLivenessSessionResult(string sessionId, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.GetLivenessSessionResult");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLivenessSessionResultRequest(sessionId, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Lists sessions for /detectLiveness/SingleModal. </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-sessions for more details. </remarks>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessSessionsAsync(string,int?,CancellationToken)']/*" />
        public virtual async Task<Response<IReadOnlyList<LivenessSessionItem>>> GetLivenessSessionsAsync(string start = null, int? top = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetLivenessSessionsAsync(start, top, context).ConfigureAwait(false);
            IReadOnlyList<LivenessSessionItem> value = default;
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            List<LivenessSessionItem> array = new List<LivenessSessionItem>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LivenessSessionItem.DeserializeLivenessSessionItem(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary> Lists sessions for /detectLiveness/SingleModal. </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-sessions for more details. </remarks>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessSessions(string,int?,CancellationToken)']/*" />
        public virtual Response<IReadOnlyList<LivenessSessionItem>> GetLivenessSessions(string start = null, int? top = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetLivenessSessions(start, top, context);
            IReadOnlyList<LivenessSessionItem> value = default;
            using var document = JsonDocument.Parse(response.ContentStream);
            List<LivenessSessionItem> array = new List<LivenessSessionItem>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LivenessSessionItem.DeserializeLivenessSessionItem(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary>
        /// [Protocol Method] Lists sessions for /detectLiveness/SingleModal.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLivenessSessionsAsync(string,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessSessionsAsync(string,int?,RequestContext)']/*" />
        public virtual async Task<Response> GetLivenessSessionsAsync(string start, int? top, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.GetLivenessSessions");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLivenessSessionsRequest(start, top, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Lists sessions for /detectLiveness/SingleModal.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLivenessSessions(string,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessSessions(string,int?,RequestContext)']/*" />
        public virtual Response GetLivenessSessions(string start, int? top, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.GetLivenessSessions");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLivenessSessionsRequest(start, top, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-session-audit-entries for more details. </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessSessionAuditEntriesAsync(string,string,int?,CancellationToken)']/*" />
        public virtual async Task<Response<IReadOnlyList<LivenessSessionAuditEntry>>> GetLivenessSessionAuditEntriesAsync(string sessionId, string start = null, int? top = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetLivenessSessionAuditEntriesAsync(sessionId, start, top, context).ConfigureAwait(false);
            IReadOnlyList<LivenessSessionAuditEntry> value = default;
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            List<LivenessSessionAuditEntry> array = new List<LivenessSessionAuditEntry>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LivenessSessionAuditEntry.DeserializeLivenessSessionAuditEntry(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-session-audit-entries for more details. </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessSessionAuditEntries(string,string,int?,CancellationToken)']/*" />
        public virtual Response<IReadOnlyList<LivenessSessionAuditEntry>> GetLivenessSessionAuditEntries(string sessionId, string start = null, int? top = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetLivenessSessionAuditEntries(sessionId, start, top, context);
            IReadOnlyList<LivenessSessionAuditEntry> value = default;
            using var document = JsonDocument.Parse(response.ContentStream);
            List<LivenessSessionAuditEntry> array = new List<LivenessSessionAuditEntry>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LivenessSessionAuditEntry.DeserializeLivenessSessionAuditEntry(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-session-audit-entries for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLivenessSessionAuditEntriesAsync(string,string,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessSessionAuditEntriesAsync(string,string,int?,RequestContext)']/*" />
        public virtual async Task<Response> GetLivenessSessionAuditEntriesAsync(string sessionId, string start, int? top, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.GetLivenessSessionAuditEntries");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLivenessSessionAuditEntriesRequest(sessionId, start, top, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-session-audit-entries for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLivenessSessionAuditEntries(string,string,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessSessionAuditEntries(string,string,int?,RequestContext)']/*" />
        public virtual Response GetLivenessSessionAuditEntries(string sessionId, string start, int? top, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.GetLivenessSessionAuditEntries");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLivenessSessionAuditEntriesRequest(sessionId, start, top, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Create a new liveness session with verify. Client device submits VerifyImage during the /detectLivenessWithVerify/singleModal call. </summary>
        /// <param name="body"> Body parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/create-liveness-with-verify-session for more details. </remarks>
        internal virtual async Task<Response<CreateLivenessWithVerifySessionResult>> CreateLivenessWithVerifySessionAsync(CreateLivenessWithVerifySessionContent body, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(body, nameof(body));

            using RequestContent content = body.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await CreateLivenessWithVerifySessionAsync(content, context).ConfigureAwait(false);
            return Response.FromValue(CreateLivenessWithVerifySessionResult.FromResponse(response), response);
        }

        /// <summary> Create a new liveness session with verify. Client device submits VerifyImage during the /detectLivenessWithVerify/singleModal call. </summary>
        /// <param name="body"> Body parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/create-liveness-with-verify-session for more details. </remarks>
        internal virtual Response<CreateLivenessWithVerifySessionResult> CreateLivenessWithVerifySession(CreateLivenessWithVerifySessionContent body, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(body, nameof(body));

            using RequestContent content = body.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = CreateLivenessWithVerifySession(content, context);
            return Response.FromValue(CreateLivenessWithVerifySessionResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Create a new liveness session with verify. Client device submits VerifyImage during the /detectLivenessWithVerify/singleModal call.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateLivenessWithVerifySessionAsync(CreateLivenessWithVerifySessionContent,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual async Task<Response> CreateLivenessWithVerifySessionAsync(RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.CreateLivenessWithVerifySession");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateLivenessWithVerifySessionRequest(content, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Create a new liveness session with verify. Client device submits VerifyImage during the /detectLivenessWithVerify/singleModal call.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateLivenessWithVerifySession(CreateLivenessWithVerifySessionContent,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual Response CreateLivenessWithVerifySession(RequestContent content, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.CreateLivenessWithVerifySession");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateLivenessWithVerifySessionRequest(content, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Create a new liveness session with verify. Provide the verify image during session creation. </summary>
        /// <param name="body"> Request content of liveness with verify session creation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/create-liveness-with-verify-session-with-verify-image for more details. </remarks>
        internal virtual async Task<Response<CreateLivenessWithVerifySessionResult>> CreateLivenessWithVerifySessionWithVerifyImageAsync(CreateLivenessWithVerifySessionMultipartContent body, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(body, nameof(body));

            using MultipartFormDataRequestContent content = body.ToMultipartRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await CreateLivenessWithVerifySessionWithVerifyImageAsync(content, content.ContentType, context).ConfigureAwait(false);
            return Response.FromValue(CreateLivenessWithVerifySessionResult.FromResponse(response), response);
        }

        /// <summary> Create a new liveness session with verify. Provide the verify image during session creation. </summary>
        /// <param name="body"> Request content of liveness with verify session creation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/create-liveness-with-verify-session-with-verify-image for more details. </remarks>
        internal virtual Response<CreateLivenessWithVerifySessionResult> CreateLivenessWithVerifySessionWithVerifyImage(CreateLivenessWithVerifySessionMultipartContent body, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(body, nameof(body));

            using MultipartFormDataRequestContent content = body.ToMultipartRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = CreateLivenessWithVerifySessionWithVerifyImage(content, content.ContentType, context);
            return Response.FromValue(CreateLivenessWithVerifySessionResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Create a new liveness session with verify. Provide the verify image during session creation.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateLivenessWithVerifySessionWithVerifyImageAsync(CreateLivenessWithVerifySessionMultipartContent,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="contentType"> The content type for the operation. Always multipart/form-data for this operation. Allowed values: "multipart/form-data". </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual async Task<Response> CreateLivenessWithVerifySessionWithVerifyImageAsync(RequestContent content, string contentType, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.CreateLivenessWithVerifySessionWithVerifyImage");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateLivenessWithVerifySessionWithVerifyImageRequest(content, contentType, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Create a new liveness session with verify. Provide the verify image during session creation.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateLivenessWithVerifySessionWithVerifyImage(CreateLivenessWithVerifySessionMultipartContent,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="contentType"> The content type for the operation. Always multipart/form-data for this operation. Allowed values: "multipart/form-data". </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual Response CreateLivenessWithVerifySessionWithVerifyImage(RequestContent content, string contentType, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.CreateLivenessWithVerifySessionWithVerifyImage");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateLivenessWithVerifySessionWithVerifyImageRequest(content, contentType, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Delete all session related information for matching the specified session id.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='DeleteLivenessWithVerifySessionAsync(string,RequestContext)']/*" />
        public virtual async Task<Response> DeleteLivenessWithVerifySessionAsync(string sessionId, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.DeleteLivenessWithVerifySession");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteLivenessWithVerifySessionRequest(sessionId, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Delete all session related information for matching the specified session id.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='DeleteLivenessWithVerifySession(string,RequestContext)']/*" />
        public virtual Response DeleteLivenessWithVerifySession(string sessionId, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.DeleteLivenessWithVerifySession");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteLivenessWithVerifySessionRequest(sessionId, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-with-verify-session-result for more details. </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessWithVerifySessionResultAsync(string,CancellationToken)']/*" />
        public virtual async Task<Response<LivenessWithVerifySession>> GetLivenessWithVerifySessionResultAsync(string sessionId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetLivenessWithVerifySessionResultAsync(sessionId, context).ConfigureAwait(false);
            return Response.FromValue(LivenessWithVerifySession.FromResponse(response), response);
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-with-verify-session-result for more details. </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessWithVerifySessionResult(string,CancellationToken)']/*" />
        public virtual Response<LivenessWithVerifySession> GetLivenessWithVerifySessionResult(string sessionId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetLivenessWithVerifySessionResult(sessionId, context);
            return Response.FromValue(LivenessWithVerifySession.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-with-verify-session-result for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLivenessWithVerifySessionResultAsync(string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessWithVerifySessionResultAsync(string,RequestContext)']/*" />
        public virtual async Task<Response> GetLivenessWithVerifySessionResultAsync(string sessionId, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.GetLivenessWithVerifySessionResult");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLivenessWithVerifySessionResultRequest(sessionId, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-with-verify-session-result for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLivenessWithVerifySessionResult(string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessWithVerifySessionResult(string,RequestContext)']/*" />
        public virtual Response GetLivenessWithVerifySessionResult(string sessionId, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.GetLivenessWithVerifySessionResult");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLivenessWithVerifySessionResultRequest(sessionId, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Lists sessions for /detectLivenessWithVerify/SingleModal. </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-with-verify-sessions for more details. </remarks>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessWithVerifySessionsAsync(string,int?,CancellationToken)']/*" />
        public virtual async Task<Response<IReadOnlyList<LivenessSessionItem>>> GetLivenessWithVerifySessionsAsync(string start = null, int? top = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetLivenessWithVerifySessionsAsync(start, top, context).ConfigureAwait(false);
            IReadOnlyList<LivenessSessionItem> value = default;
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            List<LivenessSessionItem> array = new List<LivenessSessionItem>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LivenessSessionItem.DeserializeLivenessSessionItem(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary> Lists sessions for /detectLivenessWithVerify/SingleModal. </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-with-verify-sessions for more details. </remarks>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessWithVerifySessions(string,int?,CancellationToken)']/*" />
        public virtual Response<IReadOnlyList<LivenessSessionItem>> GetLivenessWithVerifySessions(string start = null, int? top = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetLivenessWithVerifySessions(start, top, context);
            IReadOnlyList<LivenessSessionItem> value = default;
            using var document = JsonDocument.Parse(response.ContentStream);
            List<LivenessSessionItem> array = new List<LivenessSessionItem>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LivenessSessionItem.DeserializeLivenessSessionItem(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary>
        /// [Protocol Method] Lists sessions for /detectLivenessWithVerify/SingleModal.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLivenessWithVerifySessionsAsync(string,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessWithVerifySessionsAsync(string,int?,RequestContext)']/*" />
        public virtual async Task<Response> GetLivenessWithVerifySessionsAsync(string start, int? top, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.GetLivenessWithVerifySessions");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLivenessWithVerifySessionsRequest(start, top, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Lists sessions for /detectLivenessWithVerify/SingleModal.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLivenessWithVerifySessions(string,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessWithVerifySessions(string,int?,RequestContext)']/*" />
        public virtual Response GetLivenessWithVerifySessions(string start, int? top, RequestContext context)
        {
            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.GetLivenessWithVerifySessions");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLivenessWithVerifySessionsRequest(start, top, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-with-verify-session-audit-entries for more details. </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessWithVerifySessionAuditEntriesAsync(string,string,int?,CancellationToken)']/*" />
        public virtual async Task<Response<IReadOnlyList<LivenessSessionAuditEntry>>> GetLivenessWithVerifySessionAuditEntriesAsync(string sessionId, string start = null, int? top = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetLivenessWithVerifySessionAuditEntriesAsync(sessionId, start, top, context).ConfigureAwait(false);
            IReadOnlyList<LivenessSessionAuditEntry> value = default;
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            List<LivenessSessionAuditEntry> array = new List<LivenessSessionAuditEntry>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LivenessSessionAuditEntry.DeserializeLivenessSessionAuditEntry(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-with-verify-session-audit-entries for more details. </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessWithVerifySessionAuditEntries(string,string,int?,CancellationToken)']/*" />
        public virtual Response<IReadOnlyList<LivenessSessionAuditEntry>> GetLivenessWithVerifySessionAuditEntries(string sessionId, string start = null, int? top = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetLivenessWithVerifySessionAuditEntries(sessionId, start, top, context);
            IReadOnlyList<LivenessSessionAuditEntry> value = default;
            using var document = JsonDocument.Parse(response.ContentStream);
            List<LivenessSessionAuditEntry> array = new List<LivenessSessionAuditEntry>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(LivenessSessionAuditEntry.DeserializeLivenessSessionAuditEntry(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-with-verify-session-audit-entries for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLivenessWithVerifySessionAuditEntriesAsync(string,string,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessWithVerifySessionAuditEntriesAsync(string,string,int?,RequestContext)']/*" />
        public virtual async Task<Response> GetLivenessWithVerifySessionAuditEntriesAsync(string sessionId, string start, int? top, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.GetLivenessWithVerifySessionAuditEntries");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLivenessWithVerifySessionAuditEntriesRequest(sessionId, start, top, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-liveness-with-verify-session-audit-entries for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLivenessWithVerifySessionAuditEntries(string,string,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sessionId"> The unique ID to reference this session. </param>
        /// <param name="start"> List resources greater than the "start". It contains no more than 64 characters. Default is empty. </param>
        /// <param name="top"> The number of items to list, ranging in [1, 1000]. Default is 1000. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetLivenessWithVerifySessionAuditEntries(string,string,int?,RequestContext)']/*" />
        public virtual Response GetLivenessWithVerifySessionAuditEntries(string sessionId, string start, int? top, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(sessionId, nameof(sessionId));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.GetLivenessWithVerifySessionAuditEntries");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLivenessWithVerifySessionAuditEntriesRequest(sessionId, start, top, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Detect human faces in an image, return face rectangles, and optionally with faceIds, landmarks, and attributes. </summary>
        /// <param name="sessionImageId"> Id of session image. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. 'detection_03' is recommended since its accuracy is improved on smaller faces (64x64 pixels) and rotated face orientations. </param>
        /// <param name="recognitionModel"> The 'recognitionModel' associated with the detected faceIds. Supported 'recognitionModel' values include 'recognition_01', 'recognition_02', 'recognition_03' or 'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and 'recognition_02'. </param>
        /// <param name="returnFaceId"> Return faceIds of the detected faces or not. The default value is true. </param>
        /// <param name="returnFaceAttributes"> Analyze and return the one or more specified face attributes in the comma-separated string like 'returnFaceAttributes=headPose,glasses'. Face attribute analysis has additional computational and time cost. </param>
        /// <param name="returnFaceLandmarks"> Return face landmarks of the detected faces or not. The default value is false. </param>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. This is only applicable when returnFaceId = true. </param>
        /// <param name="faceIdTimeToLive"> The number of seconds for the face ID being cached. Supported range from 60 seconds up to 86400 seconds. The default value is 86400 (24 hours). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionImageId"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/face-detection-operations/detect-from-session-image-id for more details. </remarks>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='DetectFromSessionImageAsync(string,FaceDetectionModel?,FaceRecognitionModel?,bool?,IEnumerable{FaceAttributeType},bool?,bool?,int?,CancellationToken)']/*" />
        public virtual async Task<Response<IReadOnlyList<FaceDetectionResult>>> DetectFromSessionImageAsync(string sessionImageId, FaceDetectionModel? detectionModel = null, FaceRecognitionModel? recognitionModel = null, bool? returnFaceId = null, IEnumerable<FaceAttributeType> returnFaceAttributes = null, bool? returnFaceLandmarks = null, bool? returnRecognitionModel = null, int? faceIdTimeToLive = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(sessionImageId, nameof(sessionImageId));

            DetectFromSessionImageRequest detectFromSessionImageRequest = new DetectFromSessionImageRequest(sessionImageId, null);
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await DetectFromSessionImageAsync(detectFromSessionImageRequest.ToRequestContent(), detectionModel?.ToString(), recognitionModel?.ToString(), returnFaceId, returnFaceAttributes, returnFaceLandmarks, returnRecognitionModel, faceIdTimeToLive, context).ConfigureAwait(false);
            IReadOnlyList<FaceDetectionResult> value = default;
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            List<FaceDetectionResult> array = new List<FaceDetectionResult>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(FaceDetectionResult.DeserializeFaceDetectionResult(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary> Detect human faces in an image, return face rectangles, and optionally with faceIds, landmarks, and attributes. </summary>
        /// <param name="sessionImageId"> Id of session image. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. 'detection_03' is recommended since its accuracy is improved on smaller faces (64x64 pixels) and rotated face orientations. </param>
        /// <param name="recognitionModel"> The 'recognitionModel' associated with the detected faceIds. Supported 'recognitionModel' values include 'recognition_01', 'recognition_02', 'recognition_03' or 'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and 'recognition_02'. </param>
        /// <param name="returnFaceId"> Return faceIds of the detected faces or not. The default value is true. </param>
        /// <param name="returnFaceAttributes"> Analyze and return the one or more specified face attributes in the comma-separated string like 'returnFaceAttributes=headPose,glasses'. Face attribute analysis has additional computational and time cost. </param>
        /// <param name="returnFaceLandmarks"> Return face landmarks of the detected faces or not. The default value is false. </param>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. This is only applicable when returnFaceId = true. </param>
        /// <param name="faceIdTimeToLive"> The number of seconds for the face ID being cached. Supported range from 60 seconds up to 86400 seconds. The default value is 86400 (24 hours). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionImageId"/> is null. </exception>
        /// <remarks> Please refer to https://learn.microsoft.com/rest/api/face/face-detection-operations/detect-from-session-image-id for more details. </remarks>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='DetectFromSessionImage(string,FaceDetectionModel?,FaceRecognitionModel?,bool?,IEnumerable{FaceAttributeType},bool?,bool?,int?,CancellationToken)']/*" />
        public virtual Response<IReadOnlyList<FaceDetectionResult>> DetectFromSessionImage(string sessionImageId, FaceDetectionModel? detectionModel = null, FaceRecognitionModel? recognitionModel = null, bool? returnFaceId = null, IEnumerable<FaceAttributeType> returnFaceAttributes = null, bool? returnFaceLandmarks = null, bool? returnRecognitionModel = null, int? faceIdTimeToLive = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(sessionImageId, nameof(sessionImageId));

            DetectFromSessionImageRequest detectFromSessionImageRequest = new DetectFromSessionImageRequest(sessionImageId, null);
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = DetectFromSessionImage(detectFromSessionImageRequest.ToRequestContent(), detectionModel?.ToString(), recognitionModel?.ToString(), returnFaceId, returnFaceAttributes, returnFaceLandmarks, returnRecognitionModel, faceIdTimeToLive, context);
            IReadOnlyList<FaceDetectionResult> value = default;
            using var document = JsonDocument.Parse(response.ContentStream);
            List<FaceDetectionResult> array = new List<FaceDetectionResult>();
            foreach (var item in document.RootElement.EnumerateArray())
            {
                array.Add(FaceDetectionResult.DeserializeFaceDetectionResult(item));
            }
            value = array;
            return Response.FromValue(value, response);
        }

        /// <summary>
        /// [Protocol Method] Detect human faces in an image, return face rectangles, and optionally with faceIds, landmarks, and attributes.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="DetectFromSessionImageAsync(string,FaceDetectionModel?,FaceRecognitionModel?,bool?,IEnumerable{FaceAttributeType},bool?,bool?,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. 'detection_03' is recommended since its accuracy is improved on smaller faces (64x64 pixels) and rotated face orientations. Allowed values: "detection_01" | "detection_02" | "detection_03". </param>
        /// <param name="recognitionModel"> The 'recognitionModel' associated with the detected faceIds. Supported 'recognitionModel' values include 'recognition_01', 'recognition_02', 'recognition_03' or 'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and 'recognition_02'. Allowed values: "recognition_01" | "recognition_02" | "recognition_03" | "recognition_04". </param>
        /// <param name="returnFaceId"> Return faceIds of the detected faces or not. The default value is true. </param>
        /// <param name="returnFaceAttributes"> Analyze and return the one or more specified face attributes in the comma-separated string like 'returnFaceAttributes=headPose,glasses'. Face attribute analysis has additional computational and time cost. </param>
        /// <param name="returnFaceLandmarks"> Return face landmarks of the detected faces or not. The default value is false. </param>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. This is only applicable when returnFaceId = true. </param>
        /// <param name="faceIdTimeToLive"> The number of seconds for the face ID being cached. Supported range from 60 seconds up to 86400 seconds. The default value is 86400 (24 hours). </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='DetectFromSessionImageAsync(RequestContent,string,string,bool?,IEnumerable{FaceAttributeType},bool?,bool?,int?,RequestContext)']/*" />
        public virtual async Task<Response> DetectFromSessionImageAsync(RequestContent content, string detectionModel = null, string recognitionModel = null, bool? returnFaceId = null, IEnumerable<FaceAttributeType> returnFaceAttributes = null, bool? returnFaceLandmarks = null, bool? returnRecognitionModel = null, int? faceIdTimeToLive = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.DetectFromSessionImage");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDetectFromSessionImageRequest(content, detectionModel, recognitionModel, returnFaceId, returnFaceAttributes, returnFaceLandmarks, returnRecognitionModel, faceIdTimeToLive, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Detect human faces in an image, return face rectangles, and optionally with faceIds, landmarks, and attributes.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="DetectFromSessionImage(string,FaceDetectionModel?,FaceRecognitionModel?,bool?,IEnumerable{FaceAttributeType},bool?,bool?,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="detectionModel"> The 'detectionModel' associated with the detected faceIds. Supported 'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default value is 'detection_01'. 'detection_03' is recommended since its accuracy is improved on smaller faces (64x64 pixels) and rotated face orientations. Allowed values: "detection_01" | "detection_02" | "detection_03". </param>
        /// <param name="recognitionModel"> The 'recognitionModel' associated with the detected faceIds. Supported 'recognitionModel' values include 'recognition_01', 'recognition_02', 'recognition_03' or 'recognition_04'. The default value is 'recognition_01'. 'recognition_04' is recommended since its accuracy is improved on faces wearing masks compared with 'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and 'recognition_02'. Allowed values: "recognition_01" | "recognition_02" | "recognition_03" | "recognition_04". </param>
        /// <param name="returnFaceId"> Return faceIds of the detected faces or not. The default value is true. </param>
        /// <param name="returnFaceAttributes"> Analyze and return the one or more specified face attributes in the comma-separated string like 'returnFaceAttributes=headPose,glasses'. Face attribute analysis has additional computational and time cost. </param>
        /// <param name="returnFaceLandmarks"> Return face landmarks of the detected faces or not. The default value is false. </param>
        /// <param name="returnRecognitionModel"> Return 'recognitionModel' or not. The default value is false. This is only applicable when returnFaceId = true. </param>
        /// <param name="faceIdTimeToLive"> The number of seconds for the face ID being cached. Supported range from 60 seconds up to 86400 seconds. The default value is 86400 (24 hours). </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='DetectFromSessionImage(RequestContent,string,string,bool?,IEnumerable{FaceAttributeType},bool?,bool?,int?,RequestContext)']/*" />
        public virtual Response DetectFromSessionImage(RequestContent content, string detectionModel = null, string recognitionModel = null, bool? returnFaceId = null, IEnumerable<FaceAttributeType> returnFaceAttributes = null, bool? returnFaceLandmarks = null, bool? returnRecognitionModel = null, int? faceIdTimeToLive = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.DetectFromSessionImage");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDetectFromSessionImageRequest(content, detectionModel, recognitionModel, returnFaceId, returnFaceAttributes, returnFaceLandmarks, returnRecognitionModel, faceIdTimeToLive, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-session-image for more details. </summary>
        /// <param name="sessionImageId"> The request ID of the image to be retrieved. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionImageId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionImageId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetSessionImageAsync(string,CancellationToken)']/*" />
        public virtual async Task<Response<BinaryData>> GetSessionImageAsync(string sessionImageId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sessionImageId, nameof(sessionImageId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetSessionImageAsync(sessionImageId, context).ConfigureAwait(false);
            return Response.FromValue(response.Content, response);
        }

        /// <summary> Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-session-image for more details. </summary>
        /// <param name="sessionImageId"> The request ID of the image to be retrieved. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionImageId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionImageId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetSessionImage(string,CancellationToken)']/*" />
        public virtual Response<BinaryData> GetSessionImage(string sessionImageId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(sessionImageId, nameof(sessionImageId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetSessionImage(sessionImageId, context);
            return Response.FromValue(response.Content, response);
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-session-image for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetSessionImageAsync(string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sessionImageId"> The request ID of the image to be retrieved. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionImageId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionImageId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetSessionImageAsync(string,RequestContext)']/*" />
        public virtual async Task<Response> GetSessionImageAsync(string sessionImageId, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(sessionImageId, nameof(sessionImageId));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.GetSessionImage");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetSessionImageRequest(sessionImageId, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Please refer to https://learn.microsoft.com/rest/api/face/liveness-session-operations/get-session-image for more details.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetSessionImage(string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="sessionImageId"> The request ID of the image to be retrieved. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionImageId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="sessionImageId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/FaceSessionClient.xml" path="doc/members/member[@name='GetSessionImage(string,RequestContext)']/*" />
        public virtual Response GetSessionImage(string sessionImageId, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(sessionImageId, nameof(sessionImageId));

            using var scope = ClientDiagnostics.CreateScope("FaceSessionClient.GetSessionImage");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetSessionImageRequest(sessionImageId, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        internal HttpMessage CreateCreateLivenessSessionRequest(RequestContent content, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/detectLiveness/singleModal/sessions", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateDeleteLivenessSessionRequest(string sessionId, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/detectLiveness/singleModal/sessions/", false);
            uri.AppendPath(sessionId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetLivenessSessionResultRequest(string sessionId, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/detectLiveness/singleModal/sessions/", false);
            uri.AppendPath(sessionId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetLivenessSessionsRequest(string start, int? top, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/detectLiveness/singleModal/sessions", false);
            if (start != null)
            {
                uri.AppendQuery("start", start, true);
            }
            if (top != null)
            {
                uri.AppendQuery("top", top.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetLivenessSessionAuditEntriesRequest(string sessionId, string start, int? top, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/detectLiveness/singleModal/sessions/", false);
            uri.AppendPath(sessionId, true);
            uri.AppendPath("/audit", false);
            if (start != null)
            {
                uri.AppendQuery("start", start, true);
            }
            if (top != null)
            {
                uri.AppendQuery("top", top.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateCreateLivenessWithVerifySessionRequest(RequestContent content, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/detectLivenessWithVerify/singleModal/sessions", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateCreateLivenessWithVerifySessionWithVerifyImageRequest(RequestContent content, string contentType, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/detectLivenessWithVerify/singleModal/sessions", false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", contentType);
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateDeleteLivenessWithVerifySessionRequest(string sessionId, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/detectLivenessWithVerify/singleModal/sessions/", false);
            uri.AppendPath(sessionId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetLivenessWithVerifySessionResultRequest(string sessionId, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/detectLivenessWithVerify/singleModal/sessions/", false);
            uri.AppendPath(sessionId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetLivenessWithVerifySessionsRequest(string start, int? top, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/detectLivenessWithVerify/singleModal/sessions", false);
            if (start != null)
            {
                uri.AppendQuery("start", start, true);
            }
            if (top != null)
            {
                uri.AppendQuery("top", top.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetLivenessWithVerifySessionAuditEntriesRequest(string sessionId, string start, int? top, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/detectLivenessWithVerify/singleModal/sessions/", false);
            uri.AppendPath(sessionId, true);
            uri.AppendPath("/audit", false);
            if (start != null)
            {
                uri.AppendQuery("start", start, true);
            }
            if (top != null)
            {
                uri.AppendQuery("top", top.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateDetectFromSessionImageRequest(RequestContent content, string detectionModel, string recognitionModel, bool? returnFaceId, IEnumerable<FaceAttributeType> returnFaceAttributes, bool? returnFaceLandmarks, bool? returnRecognitionModel, int? faceIdTimeToLive, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/detect", false);
            if (detectionModel != null)
            {
                uri.AppendQuery("detectionModel", detectionModel, true);
            }
            if (recognitionModel != null)
            {
                uri.AppendQuery("recognitionModel", recognitionModel, true);
            }
            if (returnFaceId != null)
            {
                uri.AppendQuery("returnFaceId", returnFaceId.Value, true);
            }
            if (returnFaceAttributes != null && !(returnFaceAttributes is ChangeTrackingList<FaceAttributeType> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("returnFaceAttributes", returnFaceAttributes, ",", true);
            }
            if (returnFaceLandmarks != null)
            {
                uri.AppendQuery("returnFaceLandmarks", returnFaceLandmarks.Value, true);
            }
            if (returnRecognitionModel != null)
            {
                uri.AppendQuery("returnRecognitionModel", returnRecognitionModel.Value, true);
            }
            if (faceIdTimeToLive != null)
            {
                uri.AppendQuery("faceIdTimeToLive", faceIdTimeToLive.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateGetSessionImageRequest(string sessionImageId, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/face/", false);
            uri.AppendRaw(_apiVersion, true);
            uri.AppendPath("/session/sessionImages/", false);
            uri.AppendPath(sessionImageId, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/octet-stream");
            return message;
        }

        private static RequestContext DefaultRequestContext = new RequestContext();
        internal static RequestContext FromCancellationToken(CancellationToken cancellationToken = default)
        {
            if (!cancellationToken.CanBeCanceled)
            {
                return DefaultRequestContext;
            }

            return new RequestContext() { CancellationToken = cancellationToken };
        }

        private static ResponseClassifier _responseClassifier200;
        private static ResponseClassifier ResponseClassifier200 => _responseClassifier200 ??= new StatusCodeClassifier(stackalloc ushort[] { 200 });
    }
}
