// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Vision.Face
{
    /// <summary> A rectangle within which a face can be found. </summary>
    public partial class FaceRectangle
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FaceRectangle"/>. </summary>
        /// <param name="top"> The distance from the top edge if the image to the top edge of the rectangle, in pixels. </param>
        /// <param name="left"> The distance from the left edge if the image to the left edge of the rectangle, in pixels. </param>
        /// <param name="width"> The width of the rectangle, in pixels. </param>
        /// <param name="height"> The height of the rectangle, in pixels. </param>
        internal FaceRectangle(int top, int left, int width, int height)
        {
            Top = top;
            Left = left;
            Width = width;
            Height = height;
        }

        /// <summary> Initializes a new instance of <see cref="FaceRectangle"/>. </summary>
        /// <param name="top"> The distance from the top edge if the image to the top edge of the rectangle, in pixels. </param>
        /// <param name="left"> The distance from the left edge if the image to the left edge of the rectangle, in pixels. </param>
        /// <param name="width"> The width of the rectangle, in pixels. </param>
        /// <param name="height"> The height of the rectangle, in pixels. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FaceRectangle(int top, int left, int width, int height, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Top = top;
            Left = left;
            Width = width;
            Height = height;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FaceRectangle"/> for deserialization. </summary>
        internal FaceRectangle()
        {
        }

        /// <summary> The distance from the top edge if the image to the top edge of the rectangle, in pixels. </summary>
        public int Top { get; }
        /// <summary> The distance from the left edge if the image to the left edge of the rectangle, in pixels. </summary>
        public int Left { get; }
        /// <summary> The width of the rectangle, in pixels. </summary>
        public int Width { get; }
        /// <summary> The height of the rectangle, in pixels. </summary>
        public int Height { get; }
    }
}
