// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Vision.Face
{
    public partial class FaceLandmarks : IUtf8JsonSerializable, IJsonModel<FaceLandmarks>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FaceLandmarks>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FaceLandmarks>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FaceLandmarks>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FaceLandmarks)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("pupilLeft"u8);
            writer.WriteObjectValue(PupilLeft, options);
            writer.WritePropertyName("pupilRight"u8);
            writer.WriteObjectValue(PupilRight, options);
            writer.WritePropertyName("noseTip"u8);
            writer.WriteObjectValue(NoseTip, options);
            writer.WritePropertyName("mouthLeft"u8);
            writer.WriteObjectValue(MouthLeft, options);
            writer.WritePropertyName("mouthRight"u8);
            writer.WriteObjectValue(MouthRight, options);
            writer.WritePropertyName("eyebrowLeftOuter"u8);
            writer.WriteObjectValue(EyebrowLeftOuter, options);
            writer.WritePropertyName("eyebrowLeftInner"u8);
            writer.WriteObjectValue(EyebrowLeftInner, options);
            writer.WritePropertyName("eyeLeftOuter"u8);
            writer.WriteObjectValue(EyeLeftOuter, options);
            writer.WritePropertyName("eyeLeftTop"u8);
            writer.WriteObjectValue(EyeLeftTop, options);
            writer.WritePropertyName("eyeLeftBottom"u8);
            writer.WriteObjectValue(EyeLeftBottom, options);
            writer.WritePropertyName("eyeLeftInner"u8);
            writer.WriteObjectValue(EyeLeftInner, options);
            writer.WritePropertyName("eyebrowRightInner"u8);
            writer.WriteObjectValue(EyebrowRightInner, options);
            writer.WritePropertyName("eyebrowRightOuter"u8);
            writer.WriteObjectValue(EyebrowRightOuter, options);
            writer.WritePropertyName("eyeRightInner"u8);
            writer.WriteObjectValue(EyeRightInner, options);
            writer.WritePropertyName("eyeRightTop"u8);
            writer.WriteObjectValue(EyeRightTop, options);
            writer.WritePropertyName("eyeRightBottom"u8);
            writer.WriteObjectValue(EyeRightBottom, options);
            writer.WritePropertyName("eyeRightOuter"u8);
            writer.WriteObjectValue(EyeRightOuter, options);
            writer.WritePropertyName("noseRootLeft"u8);
            writer.WriteObjectValue(NoseRootLeft, options);
            writer.WritePropertyName("noseRootRight"u8);
            writer.WriteObjectValue(NoseRootRight, options);
            writer.WritePropertyName("noseLeftAlarTop"u8);
            writer.WriteObjectValue(NoseLeftAlarTop, options);
            writer.WritePropertyName("noseRightAlarTop"u8);
            writer.WriteObjectValue(NoseRightAlarTop, options);
            writer.WritePropertyName("noseLeftAlarOutTip"u8);
            writer.WriteObjectValue(NoseLeftAlarOutTip, options);
            writer.WritePropertyName("noseRightAlarOutTip"u8);
            writer.WriteObjectValue(NoseRightAlarOutTip, options);
            writer.WritePropertyName("upperLipTop"u8);
            writer.WriteObjectValue(UpperLipTop, options);
            writer.WritePropertyName("upperLipBottom"u8);
            writer.WriteObjectValue(UpperLipBottom, options);
            writer.WritePropertyName("underLipTop"u8);
            writer.WriteObjectValue(UnderLipTop, options);
            writer.WritePropertyName("underLipBottom"u8);
            writer.WriteObjectValue(UnderLipBottom, options);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FaceLandmarks IJsonModel<FaceLandmarks>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FaceLandmarks>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FaceLandmarks)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFaceLandmarks(document.RootElement, options);
        }

        internal static FaceLandmarks DeserializeFaceLandmarks(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            LandmarkCoordinate pupilLeft = default;
            LandmarkCoordinate pupilRight = default;
            LandmarkCoordinate noseTip = default;
            LandmarkCoordinate mouthLeft = default;
            LandmarkCoordinate mouthRight = default;
            LandmarkCoordinate eyebrowLeftOuter = default;
            LandmarkCoordinate eyebrowLeftInner = default;
            LandmarkCoordinate eyeLeftOuter = default;
            LandmarkCoordinate eyeLeftTop = default;
            LandmarkCoordinate eyeLeftBottom = default;
            LandmarkCoordinate eyeLeftInner = default;
            LandmarkCoordinate eyebrowRightInner = default;
            LandmarkCoordinate eyebrowRightOuter = default;
            LandmarkCoordinate eyeRightInner = default;
            LandmarkCoordinate eyeRightTop = default;
            LandmarkCoordinate eyeRightBottom = default;
            LandmarkCoordinate eyeRightOuter = default;
            LandmarkCoordinate noseRootLeft = default;
            LandmarkCoordinate noseRootRight = default;
            LandmarkCoordinate noseLeftAlarTop = default;
            LandmarkCoordinate noseRightAlarTop = default;
            LandmarkCoordinate noseLeftAlarOutTip = default;
            LandmarkCoordinate noseRightAlarOutTip = default;
            LandmarkCoordinate upperLipTop = default;
            LandmarkCoordinate upperLipBottom = default;
            LandmarkCoordinate underLipTop = default;
            LandmarkCoordinate underLipBottom = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("pupilLeft"u8))
                {
                    pupilLeft = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("pupilRight"u8))
                {
                    pupilRight = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("noseTip"u8))
                {
                    noseTip = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("mouthLeft"u8))
                {
                    mouthLeft = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("mouthRight"u8))
                {
                    mouthRight = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("eyebrowLeftOuter"u8))
                {
                    eyebrowLeftOuter = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("eyebrowLeftInner"u8))
                {
                    eyebrowLeftInner = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("eyeLeftOuter"u8))
                {
                    eyeLeftOuter = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("eyeLeftTop"u8))
                {
                    eyeLeftTop = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("eyeLeftBottom"u8))
                {
                    eyeLeftBottom = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("eyeLeftInner"u8))
                {
                    eyeLeftInner = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("eyebrowRightInner"u8))
                {
                    eyebrowRightInner = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("eyebrowRightOuter"u8))
                {
                    eyebrowRightOuter = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("eyeRightInner"u8))
                {
                    eyeRightInner = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("eyeRightTop"u8))
                {
                    eyeRightTop = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("eyeRightBottom"u8))
                {
                    eyeRightBottom = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("eyeRightOuter"u8))
                {
                    eyeRightOuter = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("noseRootLeft"u8))
                {
                    noseRootLeft = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("noseRootRight"u8))
                {
                    noseRootRight = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("noseLeftAlarTop"u8))
                {
                    noseLeftAlarTop = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("noseRightAlarTop"u8))
                {
                    noseRightAlarTop = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("noseLeftAlarOutTip"u8))
                {
                    noseLeftAlarOutTip = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("noseRightAlarOutTip"u8))
                {
                    noseRightAlarOutTip = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("upperLipTop"u8))
                {
                    upperLipTop = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("upperLipBottom"u8))
                {
                    upperLipBottom = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("underLipTop"u8))
                {
                    underLipTop = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (property.NameEquals("underLipBottom"u8))
                {
                    underLipBottom = LandmarkCoordinate.DeserializeLandmarkCoordinate(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FaceLandmarks(
                pupilLeft,
                pupilRight,
                noseTip,
                mouthLeft,
                mouthRight,
                eyebrowLeftOuter,
                eyebrowLeftInner,
                eyeLeftOuter,
                eyeLeftTop,
                eyeLeftBottom,
                eyeLeftInner,
                eyebrowRightInner,
                eyebrowRightOuter,
                eyeRightInner,
                eyeRightTop,
                eyeRightBottom,
                eyeRightOuter,
                noseRootLeft,
                noseRootRight,
                noseLeftAlarTop,
                noseRightAlarTop,
                noseLeftAlarOutTip,
                noseRightAlarOutTip,
                upperLipTop,
                upperLipBottom,
                underLipTop,
                underLipBottom,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<FaceLandmarks>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FaceLandmarks>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FaceLandmarks)} does not support writing '{options.Format}' format.");
            }
        }

        FaceLandmarks IPersistableModel<FaceLandmarks>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FaceLandmarks>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFaceLandmarks(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FaceLandmarks)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FaceLandmarks>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static FaceLandmarks FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeFaceLandmarks(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
