// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Vision.Face
{
    /// <summary> The type of image. </summary>
    public readonly partial struct FaceImageType : IEquatable<FaceImageType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FaceImageType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FaceImageType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ColorValue = "Color";
        private const string InfraredValue = "Infrared";
        private const string DepthValue = "Depth";

        /// <summary> Color image. </summary>
        public static FaceImageType Color { get; } = new FaceImageType(ColorValue);
        /// <summary> Infrared image. </summary>
        public static FaceImageType Infrared { get; } = new FaceImageType(InfraredValue);
        /// <summary> Depth image. </summary>
        public static FaceImageType Depth { get; } = new FaceImageType(DepthValue);
        /// <summary> Determines if two <see cref="FaceImageType"/> values are the same. </summary>
        public static bool operator ==(FaceImageType left, FaceImageType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FaceImageType"/> values are not the same. </summary>
        public static bool operator !=(FaceImageType left, FaceImageType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FaceImageType"/>. </summary>
        public static implicit operator FaceImageType(string value) => new FaceImageType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FaceImageType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FaceImageType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
