// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.Vision.Face
{
    /// <summary> Response body for group face operation. </summary>
    public partial class FaceGroupingResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FaceGroupingResult"/>. </summary>
        /// <param name="groups"> A partition of the original faces based on face similarity. Groups are ranked by number of faces. </param>
        /// <param name="messyGroup"> Face ids array of faces that cannot find any similar faces from original faces. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="groups"/> or <paramref name="messyGroup"/> is null. </exception>
        internal FaceGroupingResult(IEnumerable<IList<Guid>> groups, IEnumerable<Guid> messyGroup)
        {
            Argument.AssertNotNull(groups, nameof(groups));
            Argument.AssertNotNull(messyGroup, nameof(messyGroup));

            Groups = groups.ToList();
            MessyGroup = messyGroup.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="FaceGroupingResult"/>. </summary>
        /// <param name="groups"> A partition of the original faces based on face similarity. Groups are ranked by number of faces. </param>
        /// <param name="messyGroup"> Face ids array of faces that cannot find any similar faces from original faces. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FaceGroupingResult(IReadOnlyList<IList<Guid>> groups, IReadOnlyList<Guid> messyGroup, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Groups = groups;
            MessyGroup = messyGroup;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FaceGroupingResult"/> for deserialization. </summary>
        internal FaceGroupingResult()
        {
        }

        /// <summary> A partition of the original faces based on face similarity. Groups are ranked by number of faces. </summary>
        public IReadOnlyList<IList<Guid>> Groups { get; }
        /// <summary> Face ids array of faces that cannot find any similar faces from original faces. </summary>
        public IReadOnlyList<Guid> MessyGroup { get; }
    }
}
