// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Vision.Face
{
    public partial class FaceDetectionResult : IUtf8JsonSerializable, IJsonModel<FaceDetectionResult>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FaceDetectionResult>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FaceDetectionResult>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FaceDetectionResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FaceDetectionResult)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(FaceId))
            {
                writer.WritePropertyName("faceId"u8);
                writer.WriteStringValue(FaceId.Value);
            }
            if (Optional.IsDefined(RecognitionModel))
            {
                writer.WritePropertyName("recognitionModel"u8);
                writer.WriteStringValue(RecognitionModel.Value.ToString());
            }
            writer.WritePropertyName("faceRectangle"u8);
            writer.WriteObjectValue(FaceRectangle, options);
            if (Optional.IsDefined(FaceLandmarks))
            {
                writer.WritePropertyName("faceLandmarks"u8);
                writer.WriteObjectValue(FaceLandmarks, options);
            }
            if (Optional.IsDefined(FaceAttributes))
            {
                writer.WritePropertyName("faceAttributes"u8);
                writer.WriteObjectValue(FaceAttributes, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FaceDetectionResult IJsonModel<FaceDetectionResult>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FaceDetectionResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FaceDetectionResult)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFaceDetectionResult(document.RootElement, options);
        }

        internal static FaceDetectionResult DeserializeFaceDetectionResult(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Guid? faceId = default;
            FaceRecognitionModel? recognitionModel = default;
            FaceRectangle faceRectangle = default;
            FaceLandmarks faceLandmarks = default;
            FaceAttributes faceAttributes = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("faceId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    faceId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("recognitionModel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recognitionModel = new FaceRecognitionModel(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("faceRectangle"u8))
                {
                    faceRectangle = FaceRectangle.DeserializeFaceRectangle(property.Value, options);
                    continue;
                }
                if (property.NameEquals("faceLandmarks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    faceLandmarks = FaceLandmarks.DeserializeFaceLandmarks(property.Value, options);
                    continue;
                }
                if (property.NameEquals("faceAttributes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    faceAttributes = FaceAttributes.DeserializeFaceAttributes(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FaceDetectionResult(
                faceId,
                recognitionModel,
                faceRectangle,
                faceLandmarks,
                faceAttributes,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<FaceDetectionResult>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FaceDetectionResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FaceDetectionResult)} does not support writing '{options.Format}' format.");
            }
        }

        FaceDetectionResult IPersistableModel<FaceDetectionResult>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FaceDetectionResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFaceDetectionResult(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FaceDetectionResult)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FaceDetectionResult>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static FaceDetectionResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeFaceDetectionResult(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
