// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.IO;

namespace Azure.AI.Vision.Face
{
    /// <summary> Request of liveness with verify session creation. </summary>
    internal partial class CreateLivenessWithVerifySessionMultipartContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CreateLivenessWithVerifySessionMultipartContent"/>. </summary>
        /// <param name="parameters"> The parameters for creating session. </param>
        /// <param name="verifyImage"> The image stream for verify. Content-Disposition header field for this part must have filename. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="parameters"/> or <paramref name="verifyImage"/> is null. </exception>
        public CreateLivenessWithVerifySessionMultipartContent(CreateLivenessWithVerifySessionContent parameters, Stream verifyImage)
        {
            Argument.AssertNotNull(parameters, nameof(parameters));
            Argument.AssertNotNull(verifyImage, nameof(verifyImage));

            Parameters = parameters;
            VerifyImage = verifyImage;
        }

        /// <summary> Initializes a new instance of <see cref="CreateLivenessWithVerifySessionMultipartContent"/>. </summary>
        /// <param name="parameters"> The parameters for creating session. </param>
        /// <param name="verifyImage"> The image stream for verify. Content-Disposition header field for this part must have filename. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CreateLivenessWithVerifySessionMultipartContent(CreateLivenessWithVerifySessionContent parameters, Stream verifyImage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Parameters = parameters;
            VerifyImage = verifyImage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CreateLivenessWithVerifySessionMultipartContent"/> for deserialization. </summary>
        internal CreateLivenessWithVerifySessionMultipartContent()
        {
        }

        /// <summary> The parameters for creating session. </summary>
        public CreateLivenessWithVerifySessionContent Parameters { get; }
        /// <summary> The image stream for verify. Content-Disposition header field for this part must have filename. </summary>
        public Stream VerifyImage { get; }
    }
}
