// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Vision.Face
{
    public partial class CreateLivenessWithVerifySessionContent : IUtf8JsonSerializable, IJsonModel<CreateLivenessWithVerifySessionContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CreateLivenessWithVerifySessionContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CreateLivenessWithVerifySessionContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CreateLivenessWithVerifySessionContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CreateLivenessWithVerifySessionContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("livenessOperationMode"u8);
            writer.WriteStringValue(LivenessOperationMode.ToString());
            if (Optional.IsDefined(SendResultsToClient))
            {
                writer.WritePropertyName("sendResultsToClient"u8);
                writer.WriteBooleanValue(SendResultsToClient.Value);
            }
            if (Optional.IsDefined(DeviceCorrelationIdSetInClient))
            {
                writer.WritePropertyName("deviceCorrelationIdSetInClient"u8);
                writer.WriteBooleanValue(DeviceCorrelationIdSetInClient.Value);
            }
            if (Optional.IsDefined(EnableSessionImage))
            {
                writer.WritePropertyName("enableSessionImage"u8);
                writer.WriteBooleanValue(EnableSessionImage.Value);
            }
            if (Optional.IsDefined(LivenessSingleModalModel))
            {
                writer.WritePropertyName("livenessSingleModalModel"u8);
                writer.WriteStringValue(LivenessSingleModalModel.Value.ToString());
            }
            if (Optional.IsDefined(DeviceCorrelationId))
            {
                writer.WritePropertyName("deviceCorrelationId"u8);
                writer.WriteStringValue(DeviceCorrelationId);
            }
            if (Optional.IsDefined(AuthTokenTimeToLiveInSeconds))
            {
                writer.WritePropertyName("authTokenTimeToLiveInSeconds"u8);
                writer.WriteNumberValue(AuthTokenTimeToLiveInSeconds.Value);
            }
            if (Optional.IsDefined(ReturnVerifyImageHash))
            {
                writer.WritePropertyName("returnVerifyImageHash"u8);
                writer.WriteBooleanValue(ReturnVerifyImageHash.Value);
            }
            if (Optional.IsDefined(VerifyConfidenceThreshold))
            {
                writer.WritePropertyName("verifyConfidenceThreshold"u8);
                writer.WriteNumberValue(VerifyConfidenceThreshold.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CreateLivenessWithVerifySessionContent IJsonModel<CreateLivenessWithVerifySessionContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CreateLivenessWithVerifySessionContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CreateLivenessWithVerifySessionContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCreateLivenessWithVerifySessionContent(document.RootElement, options);
        }

        internal static CreateLivenessWithVerifySessionContent DeserializeCreateLivenessWithVerifySessionContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            LivenessOperationMode livenessOperationMode = default;
            bool? sendResultsToClient = default;
            bool? deviceCorrelationIdSetInClient = default;
            bool? enableSessionImage = default;
            LivenessModel? livenessSingleModalModel = default;
            string deviceCorrelationId = default;
            int? authTokenTimeToLiveInSeconds = default;
            bool? returnVerifyImageHash = default;
            float? verifyConfidenceThreshold = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("livenessOperationMode"u8))
                {
                    livenessOperationMode = new LivenessOperationMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("sendResultsToClient"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sendResultsToClient = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("deviceCorrelationIdSetInClient"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    deviceCorrelationIdSetInClient = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("enableSessionImage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enableSessionImage = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("livenessSingleModalModel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    livenessSingleModalModel = new LivenessModel(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("deviceCorrelationId"u8))
                {
                    deviceCorrelationId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("authTokenTimeToLiveInSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    authTokenTimeToLiveInSeconds = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("returnVerifyImageHash"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    returnVerifyImageHash = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("verifyConfidenceThreshold"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    verifyConfidenceThreshold = property.Value.GetSingle();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CreateLivenessWithVerifySessionContent(
                livenessOperationMode,
                sendResultsToClient,
                deviceCorrelationIdSetInClient,
                enableSessionImage,
                livenessSingleModalModel,
                deviceCorrelationId,
                authTokenTimeToLiveInSeconds,
                returnVerifyImageHash,
                verifyConfidenceThreshold,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CreateLivenessWithVerifySessionContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CreateLivenessWithVerifySessionContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CreateLivenessWithVerifySessionContent)} does not support writing '{options.Format}' format.");
            }
        }

        CreateLivenessWithVerifySessionContent IPersistableModel<CreateLivenessWithVerifySessionContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CreateLivenessWithVerifySessionContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCreateLivenessWithVerifySessionContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CreateLivenessWithVerifySessionContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CreateLivenessWithVerifySessionContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static CreateLivenessWithVerifySessionContent FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeCreateLivenessWithVerifySessionContent(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
