// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Vision.Face
{
    /// <summary> Properties describing any presence of blur within the image. </summary>
    public partial class BlurProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BlurProperties"/>. </summary>
        /// <param name="blurLevel"> An enum value indicating level of blurriness. </param>
        /// <param name="value"> A number indicating level of blurriness ranging from 0 to 1. </param>
        internal BlurProperties(BlurLevel blurLevel, float value)
        {
            BlurLevel = blurLevel;
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="BlurProperties"/>. </summary>
        /// <param name="blurLevel"> An enum value indicating level of blurriness. </param>
        /// <param name="value"> A number indicating level of blurriness ranging from 0 to 1. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BlurProperties(BlurLevel blurLevel, float value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BlurLevel = blurLevel;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BlurProperties"/> for deserialization. </summary>
        internal BlurProperties()
        {
        }

        /// <summary> An enum value indicating level of blurriness. </summary>
        public BlurLevel BlurLevel { get; }
        /// <summary> A number indicating level of blurriness ranging from 0 to 1. </summary>
        public float Value { get; }
    }
}
