// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Vision.Face
{
    /// <summary> Indicates level of blurriness. </summary>
    public readonly partial struct BlurLevel : IEquatable<BlurLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BlurLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BlurLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowValue = "low";
        private const string MediumValue = "medium";
        private const string HighValue = "high";

        /// <summary> Low blur level. </summary>
        public static BlurLevel Low { get; } = new BlurLevel(LowValue);
        /// <summary> Medium blur level. </summary>
        public static BlurLevel Medium { get; } = new BlurLevel(MediumValue);
        /// <summary> High blur level. </summary>
        public static BlurLevel High { get; } = new BlurLevel(HighValue);
        /// <summary> Determines if two <see cref="BlurLevel"/> values are the same. </summary>
        public static bool operator ==(BlurLevel left, BlurLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BlurLevel"/> values are not the same. </summary>
        public static bool operator !=(BlurLevel left, BlurLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BlurLevel"/>. </summary>
        public static implicit operator BlurLevel(string value) => new BlurLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BlurLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BlurLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
