// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Vision.Face
{
    /// <summary> Audit entry for a request in the session. </summary>
    public partial class AuditRequestInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AuditRequestInfo"/>. </summary>
        /// <param name="url"> The relative URL and query of the liveness request. </param>
        /// <param name="method"> The HTTP method of the request (i.e., GET, POST, DELETE). </param>
        /// <param name="contentType"> The content type of the request. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="url"/>, <paramref name="method"/> or <paramref name="contentType"/> is null. </exception>
        internal AuditRequestInfo(string url, string method, string contentType)
        {
            Argument.AssertNotNull(url, nameof(url));
            Argument.AssertNotNull(method, nameof(method));
            Argument.AssertNotNull(contentType, nameof(contentType));

            Url = url;
            Method = method;
            ContentType = contentType;
        }

        /// <summary> Initializes a new instance of <see cref="AuditRequestInfo"/>. </summary>
        /// <param name="url"> The relative URL and query of the liveness request. </param>
        /// <param name="method"> The HTTP method of the request (i.e., GET, POST, DELETE). </param>
        /// <param name="contentLength"> The length of the request body in bytes. </param>
        /// <param name="contentType"> The content type of the request. </param>
        /// <param name="userAgent"> The user agent used to submit the request. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AuditRequestInfo(string url, string method, long? contentLength, string contentType, string userAgent, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Url = url;
            Method = method;
            ContentLength = contentLength;
            ContentType = contentType;
            UserAgent = userAgent;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AuditRequestInfo"/> for deserialization. </summary>
        internal AuditRequestInfo()
        {
        }

        /// <summary> The relative URL and query of the liveness request. </summary>
        public string Url { get; }
        /// <summary> The HTTP method of the request (i.e., GET, POST, DELETE). </summary>
        public string Method { get; }
        /// <summary> The length of the request body in bytes. </summary>
        public long? ContentLength { get; }
        /// <summary> The content type of the request. </summary>
        public string ContentType { get; }
        /// <summary> The user agent used to submit the request. </summary>
        public string UserAgent { get; }
    }
}
