// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Vision.Face
{
    /// <summary> Audit entry for a response in the session. </summary>
    public partial class AuditLivenessResponseInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AuditLivenessResponseInfo"/>. </summary>
        /// <param name="body"> The response body. The schema of this field will depend on the request.url and request.method used by the client. </param>
        /// <param name="statusCode"> The HTTP status code returned to the client. </param>
        /// <param name="latencyInMilliseconds"> The server measured latency for this request in milliseconds. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/> is null. </exception>
        internal AuditLivenessResponseInfo(LivenessResponseBody body, int statusCode, long latencyInMilliseconds)
        {
            Argument.AssertNotNull(body, nameof(body));

            Body = body;
            StatusCode = statusCode;
            LatencyInMilliseconds = latencyInMilliseconds;
        }

        /// <summary> Initializes a new instance of <see cref="AuditLivenessResponseInfo"/>. </summary>
        /// <param name="body"> The response body. The schema of this field will depend on the request.url and request.method used by the client. </param>
        /// <param name="statusCode"> The HTTP status code returned to the client. </param>
        /// <param name="latencyInMilliseconds"> The server measured latency for this request in milliseconds. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AuditLivenessResponseInfo(LivenessResponseBody body, int statusCode, long latencyInMilliseconds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Body = body;
            StatusCode = statusCode;
            LatencyInMilliseconds = latencyInMilliseconds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AuditLivenessResponseInfo"/> for deserialization. </summary>
        internal AuditLivenessResponseInfo()
        {
        }

        /// <summary> The response body. The schema of this field will depend on the request.url and request.method used by the client. </summary>
        public LivenessResponseBody Body { get; }
        /// <summary> The HTTP status code returned to the client. </summary>
        public int StatusCode { get; }
        /// <summary> The server measured latency for this request in milliseconds. </summary>
        public long LatencyInMilliseconds { get; }
    }
}
