// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Vision.Face
{
    /// <summary> Accessory item and corresponding confidence level. </summary>
    public partial class AccessoryItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AccessoryItem"/>. </summary>
        /// <param name="type"> Type of the accessory. </param>
        /// <param name="confidence"> Confidence level of the accessory type. Range between [0,1]. </param>
        internal AccessoryItem(AccessoryType type, float confidence)
        {
            Type = type;
            Confidence = confidence;
        }

        /// <summary> Initializes a new instance of <see cref="AccessoryItem"/>. </summary>
        /// <param name="type"> Type of the accessory. </param>
        /// <param name="confidence"> Confidence level of the accessory type. Range between [0,1]. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AccessoryItem(AccessoryType type, float confidence, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Type = type;
            Confidence = confidence;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AccessoryItem"/> for deserialization. </summary>
        internal AccessoryItem()
        {
        }

        /// <summary> Type of the accessory. </summary>
        public AccessoryType Type { get; }
        /// <summary> Confidence level of the accessory type. Range between [0,1]. </summary>
        public float Confidence { get; }
    }
}
