// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.Vision.Face
{
    /// <summary> Model factory for models. </summary>
    public static partial class AIVisionFaceModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Face.LargePersonGroup"/>. </summary>
        /// <param name="name"> User defined name, maximum length is 128. </param>
        /// <param name="userData"> Optional user defined data. Length should not exceed 16K. </param>
        /// <param name="recognitionModel"> Name of recognition model. Recognition model is used when the face features are extracted and associated with detected faceIds. </param>
        /// <param name="largePersonGroupId"> ID of the container. </param>
        /// <returns> A new <see cref="Face.LargePersonGroup"/> instance for mocking. </returns>
        public static LargePersonGroup LargePersonGroup(string name = null, string userData = null, FaceRecognitionModel? recognitionModel = null, string largePersonGroupId = null)
        {
            return new LargePersonGroup(name, userData, recognitionModel, largePersonGroupId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.FaceTrainingResult"/>. </summary>
        /// <param name="status"> Training status of the container. </param>
        /// <param name="createdDateTime"> A combined UTC date and time string that describes the created time of the person group, large person group or large face list. </param>
        /// <param name="lastActionDateTime"> A combined UTC date and time string that describes the last modify time of the person group, large person group or large face list, could be null value when the group is not successfully trained. </param>
        /// <param name="lastSuccessfulTrainingDateTime"> A combined UTC date and time string that describes the last successful training time of the person group, large person group or large face list. </param>
        /// <param name="message"> Show failure message when training failed (omitted when training succeed). </param>
        /// <returns> A new <see cref="Face.FaceTrainingResult"/> instance for mocking. </returns>
        public static FaceTrainingResult FaceTrainingResult(FaceOperationStatus status = default, DateTimeOffset createdDateTime = default, DateTimeOffset lastActionDateTime = default, DateTimeOffset lastSuccessfulTrainingDateTime = default, string message = null)
        {
            return new FaceTrainingResult(
                status,
                createdDateTime,
                lastActionDateTime,
                lastSuccessfulTrainingDateTime,
                message,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.CreatePersonResult"/>. </summary>
        /// <param name="personId"> Person ID of the person. </param>
        /// <returns> A new <see cref="Face.CreatePersonResult"/> instance for mocking. </returns>
        public static CreatePersonResult CreatePersonResult(Guid personId = default)
        {
            return new CreatePersonResult(personId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.LargePersonGroupPerson"/>. </summary>
        /// <param name="personId"> ID of the person. </param>
        /// <param name="name"> User defined name, maximum length is 128. </param>
        /// <param name="userData"> Optional user defined data. Length should not exceed 16K. </param>
        /// <param name="persistedFaceIds"> Face ids of registered faces in the person. </param>
        /// <returns> A new <see cref="Face.LargePersonGroupPerson"/> instance for mocking. </returns>
        public static LargePersonGroupPerson LargePersonGroupPerson(Guid personId = default, string name = null, string userData = null, IEnumerable<Guid> persistedFaceIds = null)
        {
            persistedFaceIds ??= new List<Guid>();

            return new LargePersonGroupPerson(personId, name, userData, persistedFaceIds?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.AddFaceResult"/>. </summary>
        /// <param name="persistedFaceId"> Persisted Face ID of the added face, which is persisted and will not expire. Different from faceId which is created in "Detect" and will expire in 24 hours after the detection call. </param>
        /// <returns> A new <see cref="Face.AddFaceResult"/> instance for mocking. </returns>
        public static AddFaceResult AddFaceResult(Guid persistedFaceId = default)
        {
            return new AddFaceResult(persistedFaceId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.LargePersonGroupPersonFace"/>. </summary>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="userData"> User-provided data attached to the face. The length limit is 1K. </param>
        /// <returns> A new <see cref="Face.LargePersonGroupPersonFace"/> instance for mocking. </returns>
        public static LargePersonGroupPersonFace LargePersonGroupPersonFace(Guid persistedFaceId = default, string userData = null)
        {
            return new LargePersonGroupPersonFace(persistedFaceId, userData, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.LargeFaceList"/>. </summary>
        /// <param name="name"> User defined name, maximum length is 128. </param>
        /// <param name="userData"> Optional user defined data. Length should not exceed 16K. </param>
        /// <param name="recognitionModel"> Name of recognition model. Recognition model is used when the face features are extracted and associated with detected faceIds. </param>
        /// <param name="largeFaceListId"> Valid character is letter in lower case or digit or '-' or '_', maximum length is 64. </param>
        /// <returns> A new <see cref="Face.LargeFaceList"/> instance for mocking. </returns>
        public static LargeFaceList LargeFaceList(string name = null, string userData = null, FaceRecognitionModel? recognitionModel = null, string largeFaceListId = null)
        {
            return new LargeFaceList(name, userData, recognitionModel, largeFaceListId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.LargeFaceListFace"/>. </summary>
        /// <param name="persistedFaceId"> Face ID of the face. </param>
        /// <param name="userData"> User-provided data attached to the face. The length limit is 1K. </param>
        /// <returns> A new <see cref="Face.LargeFaceListFace"/> instance for mocking. </returns>
        public static LargeFaceListFace LargeFaceListFace(Guid persistedFaceId = default, string userData = null)
        {
            return new LargeFaceListFace(persistedFaceId, userData, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.FaceDetectionResult"/>. </summary>
        /// <param name="faceId"> Unique faceId of the detected face, created by detection API and it will expire 24 hours after the detection call. To return this, it requires 'returnFaceId' parameter to be true. </param>
        /// <param name="recognitionModel"> The 'recognitionModel' associated with this faceId. This is only returned when 'returnRecognitionModel' is explicitly set as true. </param>
        /// <param name="faceRectangle"> A rectangle area for the face location on image. </param>
        /// <param name="faceLandmarks"> An array of 27-point face landmarks pointing to the important positions of face components. To return this, it requires 'returnFaceLandmarks' parameter to be true. </param>
        /// <param name="faceAttributes"> Face attributes for detected face. </param>
        /// <returns> A new <see cref="Face.FaceDetectionResult"/> instance for mocking. </returns>
        public static FaceDetectionResult FaceDetectionResult(Guid? faceId = null, FaceRecognitionModel? recognitionModel = null, FaceRectangle faceRectangle = null, FaceLandmarks faceLandmarks = null, FaceAttributes faceAttributes = null)
        {
            return new FaceDetectionResult(
                faceId,
                recognitionModel,
                faceRectangle,
                faceLandmarks,
                faceAttributes,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.FaceRectangle"/>. </summary>
        /// <param name="top"> The distance from the top edge if the image to the top edge of the rectangle, in pixels. </param>
        /// <param name="left"> The distance from the left edge if the image to the left edge of the rectangle, in pixels. </param>
        /// <param name="width"> The width of the rectangle, in pixels. </param>
        /// <param name="height"> The height of the rectangle, in pixels. </param>
        /// <returns> A new <see cref="Face.FaceRectangle"/> instance for mocking. </returns>
        public static FaceRectangle FaceRectangle(int top = default, int left = default, int width = default, int height = default)
        {
            return new FaceRectangle(top, left, width, height, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.FaceLandmarks"/>. </summary>
        /// <param name="pupilLeft"> The coordinates of the left eye pupil. </param>
        /// <param name="pupilRight"> The coordinates of the right eye pupil. </param>
        /// <param name="noseTip"> The coordinates of the nose tip. </param>
        /// <param name="mouthLeft"> The coordinates of the mouth left. </param>
        /// <param name="mouthRight"> The coordinates of the mouth right. </param>
        /// <param name="eyebrowLeftOuter"> The coordinates of the left eyebrow outer. </param>
        /// <param name="eyebrowLeftInner"> The coordinates of the left eyebrow inner. </param>
        /// <param name="eyeLeftOuter"> The coordinates of the left eye outer. </param>
        /// <param name="eyeLeftTop"> The coordinates of the left eye top. </param>
        /// <param name="eyeLeftBottom"> The coordinates of the left eye bottom. </param>
        /// <param name="eyeLeftInner"> The coordinates of the left eye inner. </param>
        /// <param name="eyebrowRightInner"> The coordinates of the right eyebrow inner. </param>
        /// <param name="eyebrowRightOuter"> The coordinates of the right eyebrow outer. </param>
        /// <param name="eyeRightInner"> The coordinates of the right eye inner. </param>
        /// <param name="eyeRightTop"> The coordinates of the right eye top. </param>
        /// <param name="eyeRightBottom"> The coordinates of the right eye bottom. </param>
        /// <param name="eyeRightOuter"> The coordinates of the right eye outer. </param>
        /// <param name="noseRootLeft"> The coordinates of the nose root left. </param>
        /// <param name="noseRootRight"> The coordinates of the nose root right. </param>
        /// <param name="noseLeftAlarTop"> The coordinates of the nose left alar top. </param>
        /// <param name="noseRightAlarTop"> The coordinates of the nose right alar top. </param>
        /// <param name="noseLeftAlarOutTip"> The coordinates of the nose left alar out tip. </param>
        /// <param name="noseRightAlarOutTip"> The coordinates of the nose right alar out tip. </param>
        /// <param name="upperLipTop"> The coordinates of the upper lip top. </param>
        /// <param name="upperLipBottom"> The coordinates of the upper lip bottom. </param>
        /// <param name="underLipTop"> The coordinates of the under lip top. </param>
        /// <param name="underLipBottom"> The coordinates of the under lip bottom. </param>
        /// <returns> A new <see cref="Face.FaceLandmarks"/> instance for mocking. </returns>
        public static FaceLandmarks FaceLandmarks(LandmarkCoordinate pupilLeft = null, LandmarkCoordinate pupilRight = null, LandmarkCoordinate noseTip = null, LandmarkCoordinate mouthLeft = null, LandmarkCoordinate mouthRight = null, LandmarkCoordinate eyebrowLeftOuter = null, LandmarkCoordinate eyebrowLeftInner = null, LandmarkCoordinate eyeLeftOuter = null, LandmarkCoordinate eyeLeftTop = null, LandmarkCoordinate eyeLeftBottom = null, LandmarkCoordinate eyeLeftInner = null, LandmarkCoordinate eyebrowRightInner = null, LandmarkCoordinate eyebrowRightOuter = null, LandmarkCoordinate eyeRightInner = null, LandmarkCoordinate eyeRightTop = null, LandmarkCoordinate eyeRightBottom = null, LandmarkCoordinate eyeRightOuter = null, LandmarkCoordinate noseRootLeft = null, LandmarkCoordinate noseRootRight = null, LandmarkCoordinate noseLeftAlarTop = null, LandmarkCoordinate noseRightAlarTop = null, LandmarkCoordinate noseLeftAlarOutTip = null, LandmarkCoordinate noseRightAlarOutTip = null, LandmarkCoordinate upperLipTop = null, LandmarkCoordinate upperLipBottom = null, LandmarkCoordinate underLipTop = null, LandmarkCoordinate underLipBottom = null)
        {
            return new FaceLandmarks(
                pupilLeft,
                pupilRight,
                noseTip,
                mouthLeft,
                mouthRight,
                eyebrowLeftOuter,
                eyebrowLeftInner,
                eyeLeftOuter,
                eyeLeftTop,
                eyeLeftBottom,
                eyeLeftInner,
                eyebrowRightInner,
                eyebrowRightOuter,
                eyeRightInner,
                eyeRightTop,
                eyeRightBottom,
                eyeRightOuter,
                noseRootLeft,
                noseRootRight,
                noseLeftAlarTop,
                noseRightAlarTop,
                noseLeftAlarOutTip,
                noseRightAlarOutTip,
                upperLipTop,
                upperLipBottom,
                underLipTop,
                underLipBottom,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.LandmarkCoordinate"/>. </summary>
        /// <param name="x"> The horizontal component, in pixels. </param>
        /// <param name="y"> The vertical component, in pixels. </param>
        /// <returns> A new <see cref="Face.LandmarkCoordinate"/> instance for mocking. </returns>
        public static LandmarkCoordinate LandmarkCoordinate(float x = default, float y = default)
        {
            return new LandmarkCoordinate(x, y, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.FaceAttributes"/>. </summary>
        /// <param name="age"> Age in years. </param>
        /// <param name="smile"> Smile intensity, a number between [0,1]. </param>
        /// <param name="facialHair"> Properties describing facial hair attributes. </param>
        /// <param name="glasses"> Glasses type if any of the face. </param>
        /// <param name="headPose"> 3-D roll/yaw/pitch angles for face direction. </param>
        /// <param name="hair"> Properties describing hair attributes. </param>
        /// <param name="occlusion"> Properties describing occlusions on a given face. </param>
        /// <param name="accessories"> Properties describing any accessories on a given face. </param>
        /// <param name="blur"> Properties describing any presence of blur within the image. </param>
        /// <param name="exposure"> Properties describing exposure level of the image. </param>
        /// <param name="noise"> Properties describing noise level of the image. </param>
        /// <param name="mask"> Properties describing the presence of a mask on a given face. </param>
        /// <param name="qualityForRecognition"> Properties describing the overall image quality regarding whether the image being used in the detection is of sufficient quality to attempt face recognition on. </param>
        /// <returns> A new <see cref="Face.FaceAttributes"/> instance for mocking. </returns>
        public static FaceAttributes FaceAttributes(float? age = null, float? smile = null, FacialHair facialHair = null, GlassesType? glasses = null, HeadPose headPose = null, HairProperties hair = null, OcclusionProperties occlusion = null, IEnumerable<AccessoryItem> accessories = null, BlurProperties blur = null, ExposureProperties exposure = null, NoiseProperties noise = null, MaskProperties mask = null, QualityForRecognition? qualityForRecognition = null)
        {
            accessories ??= new List<AccessoryItem>();

            return new FaceAttributes(
                age,
                smile,
                facialHair,
                glasses,
                headPose,
                hair,
                occlusion,
                accessories?.ToList(),
                blur,
                exposure,
                noise,
                mask,
                qualityForRecognition,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.FacialHair"/>. </summary>
        /// <param name="moustache"> A number ranging from 0 to 1 indicating a level of confidence associated with a property. </param>
        /// <param name="beard"> A number ranging from 0 to 1 indicating a level of confidence associated with a property. </param>
        /// <param name="sideburns"> A number ranging from 0 to 1 indicating a level of confidence associated with a property. </param>
        /// <returns> A new <see cref="Face.FacialHair"/> instance for mocking. </returns>
        public static FacialHair FacialHair(float moustache = default, float beard = default, float sideburns = default)
        {
            return new FacialHair(moustache, beard, sideburns, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.HeadPose"/>. </summary>
        /// <param name="pitch"> Value of angles. </param>
        /// <param name="roll"> Value of angles. </param>
        /// <param name="yaw"> Value of angles. </param>
        /// <returns> A new <see cref="Face.HeadPose"/> instance for mocking. </returns>
        public static HeadPose HeadPose(float pitch = default, float roll = default, float yaw = default)
        {
            return new HeadPose(pitch, roll, yaw, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.HairProperties"/>. </summary>
        /// <param name="bald"> A number describing confidence level of whether the person is bald. </param>
        /// <param name="invisible"> A boolean value describing whether the hair is visible in the image. </param>
        /// <param name="hairColor"> An array of candidate colors and confidence level in the presence of each. </param>
        /// <returns> A new <see cref="Face.HairProperties"/> instance for mocking. </returns>
        public static HairProperties HairProperties(float bald = default, bool invisible = default, IEnumerable<HairColor> hairColor = null)
        {
            hairColor ??= new List<HairColor>();

            return new HairProperties(bald, invisible, hairColor?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.HairColor"/>. </summary>
        /// <param name="color"> Name of the hair color. </param>
        /// <param name="confidence"> Confidence level of the color. Range between [0,1]. </param>
        /// <returns> A new <see cref="Face.HairColor"/> instance for mocking. </returns>
        public static HairColor HairColor(HairColorType color = default, float confidence = default)
        {
            return new HairColor(color, confidence, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.OcclusionProperties"/>. </summary>
        /// <param name="foreheadOccluded"> A boolean value indicating whether forehead is occluded. </param>
        /// <param name="eyeOccluded"> A boolean value indicating whether eyes are occluded. </param>
        /// <param name="mouthOccluded"> A boolean value indicating whether the mouth is occluded. </param>
        /// <returns> A new <see cref="Face.OcclusionProperties"/> instance for mocking. </returns>
        public static OcclusionProperties OcclusionProperties(bool foreheadOccluded = default, bool eyeOccluded = default, bool mouthOccluded = default)
        {
            return new OcclusionProperties(foreheadOccluded, eyeOccluded, mouthOccluded, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.AccessoryItem"/>. </summary>
        /// <param name="type"> Type of the accessory. </param>
        /// <param name="confidence"> Confidence level of the accessory type. Range between [0,1]. </param>
        /// <returns> A new <see cref="Face.AccessoryItem"/> instance for mocking. </returns>
        public static AccessoryItem AccessoryItem(AccessoryType type = default, float confidence = default)
        {
            return new AccessoryItem(type, confidence, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.BlurProperties"/>. </summary>
        /// <param name="blurLevel"> An enum value indicating level of blurriness. </param>
        /// <param name="value"> A number indicating level of blurriness ranging from 0 to 1. </param>
        /// <returns> A new <see cref="Face.BlurProperties"/> instance for mocking. </returns>
        public static BlurProperties BlurProperties(BlurLevel blurLevel = default, float value = default)
        {
            return new BlurProperties(blurLevel, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.ExposureProperties"/>. </summary>
        /// <param name="exposureLevel"> An enum value indicating level of exposure. </param>
        /// <param name="value"> A number indicating level of exposure level ranging from 0 to 1. [0, 0.25) is under exposure. [0.25, 0.75) is good exposure. [0.75, 1] is over exposure. </param>
        /// <returns> A new <see cref="Face.ExposureProperties"/> instance for mocking. </returns>
        public static ExposureProperties ExposureProperties(ExposureLevel exposureLevel = default, float value = default)
        {
            return new ExposureProperties(exposureLevel, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.NoiseProperties"/>. </summary>
        /// <param name="noiseLevel"> An enum value indicating level of noise. </param>
        /// <param name="value"> A number indicating level of noise level ranging from 0 to 1. [0, 0.25) is under exposure. [0.25, 0.75) is good exposure. [0.75, 1] is over exposure. [0, 0.3) is low noise level. [0.3, 0.7) is medium noise level. [0.7, 1] is high noise level. </param>
        /// <returns> A new <see cref="Face.NoiseProperties"/> instance for mocking. </returns>
        public static NoiseProperties NoiseProperties(NoiseLevel noiseLevel = default, float value = default)
        {
            return new NoiseProperties(noiseLevel, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.MaskProperties"/>. </summary>
        /// <param name="noseAndMouthCovered"> A boolean value indicating whether nose and mouth are covered. </param>
        /// <param name="type"> Type of the mask. </param>
        /// <returns> A new <see cref="Face.MaskProperties"/> instance for mocking. </returns>
        public static MaskProperties MaskProperties(bool noseAndMouthCovered = default, MaskType type = default)
        {
            return new MaskProperties(noseAndMouthCovered, type, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.FaceFindSimilarResult"/>. </summary>
        /// <param name="confidence"> Confidence value of the candidate. The higher confidence, the more similar. Range between [0,1]. </param>
        /// <param name="faceId"> faceId of candidate face when find by faceIds. faceId is created by "Detect" and will expire 24 hours after the detection call. </param>
        /// <param name="persistedFaceId"> persistedFaceId of candidate face when find by faceListId or largeFaceListId. persistedFaceId in face list/large face list is persisted and will not expire. </param>
        /// <returns> A new <see cref="Face.FaceFindSimilarResult"/> instance for mocking. </returns>
        public static FaceFindSimilarResult FaceFindSimilarResult(float confidence = default, Guid? faceId = null, Guid? persistedFaceId = null)
        {
            return new FaceFindSimilarResult(confidence, faceId, persistedFaceId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.FaceVerificationResult"/>. </summary>
        /// <param name="isIdentical"> True if the two faces belong to the same person or the face belongs to the person, otherwise false. </param>
        /// <param name="confidence"> A number indicates the similarity confidence of whether two faces belong to the same person, or whether the face belongs to the person. By default, isIdentical is set to True if similarity confidence is greater than or equal to 0.5. This is useful for advanced users to override 'isIdentical' and fine-tune the result on their own data. </param>
        /// <returns> A new <see cref="Face.FaceVerificationResult"/> instance for mocking. </returns>
        public static FaceVerificationResult FaceVerificationResult(bool isIdentical = default, float confidence = default)
        {
            return new FaceVerificationResult(isIdentical, confidence, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.FaceGroupingResult"/>. </summary>
        /// <param name="groups"> A partition of the original faces based on face similarity. Groups are ranked by number of faces. </param>
        /// <param name="messyGroup"> Face ids array of faces that cannot find any similar faces from original faces. </param>
        /// <returns> A new <see cref="Face.FaceGroupingResult"/> instance for mocking. </returns>
        public static FaceGroupingResult FaceGroupingResult(IEnumerable<IList<Guid>> groups = null, IEnumerable<Guid> messyGroup = null)
        {
            groups ??= new List<IList<Guid>>();
            messyGroup ??= new List<Guid>();

            return new FaceGroupingResult(groups?.ToList(), messyGroup?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.FaceIdentificationResult"/>. </summary>
        /// <param name="faceId"> faceId of the query face. </param>
        /// <param name="candidates"> Identified person candidates for that face (ranked by confidence). Array size should be no larger than input maxNumOfCandidatesReturned. If no person is identified, will return an empty array. </param>
        /// <returns> A new <see cref="Face.FaceIdentificationResult"/> instance for mocking. </returns>
        public static FaceIdentificationResult FaceIdentificationResult(Guid faceId = default, IEnumerable<FaceIdentificationCandidate> candidates = null)
        {
            candidates ??= new List<FaceIdentificationCandidate>();

            return new FaceIdentificationResult(faceId, candidates?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.FaceIdentificationCandidate"/>. </summary>
        /// <param name="personId"> personId of candidate person. </param>
        /// <param name="confidence"> Confidence value of the candidate. The higher confidence, the more similar. Range between [0,1]. </param>
        /// <returns> A new <see cref="Face.FaceIdentificationCandidate"/> instance for mocking. </returns>
        public static FaceIdentificationCandidate FaceIdentificationCandidate(Guid personId = default, float confidence = default)
        {
            return new FaceIdentificationCandidate(personId, confidence, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.CreateLivenessSessionContent"/>. </summary>
        /// <param name="livenessOperationMode"> Type of liveness mode the client should follow. </param>
        /// <param name="sendResultsToClient"> Whether or not to allow a '200 - Success' response body to be sent to the client, which may be undesirable for security reasons. Default is false, clients will receive a '204 - NoContent' empty body response. Regardless of selection, calling Session GetResult will always contain a response body enabling business logic to be implemented. </param>
        /// <param name="deviceCorrelationIdSetInClient"> Whether or not to allow client to set their own 'deviceCorrelationId' via the Vision SDK. Default is false, and 'deviceCorrelationId' must be set in this request body. </param>
        /// <param name="enableSessionImage"> Whether or not store the session image. </param>
        /// <param name="livenessSingleModalModel"> The model version used for liveness classification. This is an optional parameter, and if this is not specified, then the latest supported model version will be chosen. </param>
        /// <param name="deviceCorrelationId"> Unique Guid per each end-user device. This is to provide rate limiting and anti-hammering. If 'deviceCorrelationIdSetInClient' is true in this request, this 'deviceCorrelationId' must be null. </param>
        /// <param name="authTokenTimeToLiveInSeconds"> Seconds the session should last for. Range is 60 to 86400 seconds. Default value is 600. </param>
        /// <returns> A new <see cref="Face.CreateLivenessSessionContent"/> instance for mocking. </returns>
        public static CreateLivenessSessionContent CreateLivenessSessionContent(LivenessOperationMode livenessOperationMode = default, bool? sendResultsToClient = null, bool? deviceCorrelationIdSetInClient = null, bool? enableSessionImage = null, LivenessModel? livenessSingleModalModel = null, string deviceCorrelationId = null, int? authTokenTimeToLiveInSeconds = null)
        {
            return new CreateLivenessSessionContent(
                livenessOperationMode,
                sendResultsToClient,
                deviceCorrelationIdSetInClient,
                enableSessionImage,
                livenessSingleModalModel,
                deviceCorrelationId,
                authTokenTimeToLiveInSeconds,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.CreateLivenessSessionResult"/>. </summary>
        /// <param name="sessionId"> The unique session ID of the created session. It will expire 48 hours after it was created or may be deleted sooner using the corresponding Session DELETE operation. </param>
        /// <param name="authToken"> Bearer token to provide authentication for the Vision SDK running on a client application. This Bearer token has limited permissions to perform only the required action and expires after the TTL time. It is also auditable. </param>
        /// <returns> A new <see cref="Face.CreateLivenessSessionResult"/> instance for mocking. </returns>
        public static CreateLivenessSessionResult CreateLivenessSessionResult(string sessionId = null, string authToken = null)
        {
            return new CreateLivenessSessionResult(sessionId, authToken, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.LivenessSession"/>. </summary>
        /// <param name="id"> The unique ID to reference this session. </param>
        /// <param name="createdDateTime"> DateTime when this session was created. </param>
        /// <param name="sessionStartDateTime"> DateTime when this session was started by the client. </param>
        /// <param name="sessionExpired"> Whether or not the session is expired. </param>
        /// <param name="deviceCorrelationId"> Unique Guid per each end-user device. This is to provide rate limiting and anti-hammering. If 'deviceCorrelationIdSetInClient' is true in this request, this 'deviceCorrelationId' must be null. </param>
        /// <param name="authTokenTimeToLiveInSeconds"> Seconds the session should last for. Range is 60 to 86400 seconds. Default value is 600. </param>
        /// <param name="status"> The current status of the session. </param>
        /// <param name="result"> The latest session audit result only populated if status == 'ResultAvailable'. </param>
        /// <returns> A new <see cref="Face.LivenessSession"/> instance for mocking. </returns>
        public static LivenessSession LivenessSession(string id = null, DateTimeOffset createdDateTime = default, DateTimeOffset? sessionStartDateTime = null, bool sessionExpired = default, string deviceCorrelationId = null, int? authTokenTimeToLiveInSeconds = null, FaceSessionStatus status = default, LivenessSessionAuditEntry result = null)
        {
            return new LivenessSession(
                id,
                createdDateTime,
                sessionStartDateTime,
                sessionExpired,
                deviceCorrelationId,
                authTokenTimeToLiveInSeconds,
                status,
                result,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.LivenessSessionAuditEntry"/>. </summary>
        /// <param name="id"> The unique id to refer to this audit request. Use this id with the 'start' query parameter to continue on to the next page of audit results. </param>
        /// <param name="sessionId"> The unique sessionId of the created session. It will expire 48 hours after it was created or may be deleted sooner using the corresponding session DELETE operation. </param>
        /// <param name="requestId"> The unique requestId that is returned by the service to the client in the 'apim-request-id' header. </param>
        /// <param name="clientRequestId"> The unique clientRequestId that is sent by the client in the 'client-request-id' header. </param>
        /// <param name="receivedDateTime"> The UTC DateTime that the request was received. </param>
        /// <param name="request"> The request of this entry. </param>
        /// <param name="response"> The response of this entry. </param>
        /// <param name="digest"> The server calculated digest for this request. If the client reported digest differs from the server calculated digest, then the message integrity between the client and service has been compromised and the result should not be trusted. For more information, see how to guides on how to leverage this value to secure your end-to-end solution. </param>
        /// <param name="sessionImageId"> The image ID of the session request. </param>
        /// <param name="verifyImageHash"> The sha256 hash of the verify-image in the request. </param>
        /// <returns> A new <see cref="Face.LivenessSessionAuditEntry"/> instance for mocking. </returns>
        public static LivenessSessionAuditEntry LivenessSessionAuditEntry(long id = default, string sessionId = null, string requestId = null, string clientRequestId = null, DateTimeOffset receivedDateTime = default, AuditRequestInfo request = null, AuditLivenessResponseInfo response = null, string digest = null, string sessionImageId = null, string verifyImageHash = null)
        {
            return new LivenessSessionAuditEntry(
                id,
                sessionId,
                requestId,
                clientRequestId,
                receivedDateTime,
                request,
                response,
                digest,
                sessionImageId,
                verifyImageHash,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.AuditRequestInfo"/>. </summary>
        /// <param name="url"> The relative URL and query of the liveness request. </param>
        /// <param name="method"> The HTTP method of the request (i.e., GET, POST, DELETE). </param>
        /// <param name="contentLength"> The length of the request body in bytes. </param>
        /// <param name="contentType"> The content type of the request. </param>
        /// <param name="userAgent"> The user agent used to submit the request. </param>
        /// <returns> A new <see cref="Face.AuditRequestInfo"/> instance for mocking. </returns>
        public static AuditRequestInfo AuditRequestInfo(string url = null, string method = null, long? contentLength = null, string contentType = null, string userAgent = null)
        {
            return new AuditRequestInfo(
                url,
                method,
                contentLength,
                contentType,
                userAgent,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.AuditLivenessResponseInfo"/>. </summary>
        /// <param name="body"> The response body. The schema of this field will depend on the request.url and request.method used by the client. </param>
        /// <param name="statusCode"> The HTTP status code returned to the client. </param>
        /// <param name="latencyInMilliseconds"> The server measured latency for this request in milliseconds. </param>
        /// <returns> A new <see cref="Face.AuditLivenessResponseInfo"/> instance for mocking. </returns>
        public static AuditLivenessResponseInfo AuditLivenessResponseInfo(LivenessResponseBody body = null, int statusCode = default, long latencyInMilliseconds = default)
        {
            return new AuditLivenessResponseInfo(body, statusCode, latencyInMilliseconds, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.LivenessResponseBody"/>. </summary>
        /// <param name="livenessDecision"> The liveness classification for the target face. </param>
        /// <param name="target"> Specific targets used for liveness classification. </param>
        /// <param name="modelVersionUsed"> The model version used for liveness classification. </param>
        /// <param name="verifyResult"> The face verification output. Only available when the request is liveness with verify. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Face.LivenessResponseBody"/> instance for mocking. </returns>
        public static LivenessResponseBody LivenessResponseBody(FaceLivenessDecision? livenessDecision = null, LivenessOutputsTarget target = null, LivenessModel? modelVersionUsed = null, LivenessWithVerifyOutputs verifyResult = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new LivenessResponseBody(livenessDecision, target, modelVersionUsed, verifyResult, additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Face.LivenessOutputsTarget"/>. </summary>
        /// <param name="faceRectangle"> The face region where the liveness classification was made on. </param>
        /// <param name="fileName"> The file name which contains the face rectangle where the liveness classification was made on. </param>
        /// <param name="timeOffsetWithinFile"> The time offset within the file of the frame which contains the face rectangle where the liveness classification was made on. </param>
        /// <param name="imageType"> The image type which contains the face rectangle where the liveness classification was made on. </param>
        /// <returns> A new <see cref="Face.LivenessOutputsTarget"/> instance for mocking. </returns>
        public static LivenessOutputsTarget LivenessOutputsTarget(FaceRectangle faceRectangle = null, string fileName = null, int timeOffsetWithinFile = default, FaceImageType imageType = default)
        {
            return new LivenessOutputsTarget(faceRectangle, fileName, timeOffsetWithinFile, imageType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.LivenessWithVerifyOutputs"/>. </summary>
        /// <param name="verifyImage"> The detail of face for verification. </param>
        /// <param name="matchConfidence"> The target face liveness face and comparison image face verification confidence. </param>
        /// <param name="isIdentical"> Whether the target liveness face and comparison image face match. </param>
        /// <returns> A new <see cref="Face.LivenessWithVerifyOutputs"/> instance for mocking. </returns>
        public static LivenessWithVerifyOutputs LivenessWithVerifyOutputs(LivenessWithVerifyImage verifyImage = null, float matchConfidence = default, bool isIdentical = default)
        {
            return new LivenessWithVerifyOutputs(verifyImage, matchConfidence, isIdentical, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.LivenessWithVerifyImage"/>. </summary>
        /// <param name="faceRectangle"> The face region where the comparison image's classification was made. </param>
        /// <param name="qualityForRecognition"> Quality of face image for recognition. </param>
        /// <returns> A new <see cref="Face.LivenessWithVerifyImage"/> instance for mocking. </returns>
        public static LivenessWithVerifyImage LivenessWithVerifyImage(FaceRectangle faceRectangle = null, QualityForRecognition qualityForRecognition = default)
        {
            return new LivenessWithVerifyImage(faceRectangle, qualityForRecognition, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.LivenessSessionItem"/>. </summary>
        /// <param name="id"> The unique ID to reference this session. </param>
        /// <param name="createdDateTime"> DateTime when this session was created. </param>
        /// <param name="sessionStartDateTime"> DateTime when this session was started by the client. </param>
        /// <param name="sessionExpired"> Whether or not the session is expired. </param>
        /// <param name="deviceCorrelationId"> Unique Guid per each end-user device. This is to provide rate limiting and anti-hammering. If 'deviceCorrelationIdSetInClient' is true in this request, this 'deviceCorrelationId' must be null. </param>
        /// <param name="authTokenTimeToLiveInSeconds"> Seconds the session should last for. Range is 60 to 86400 seconds. Default value is 600. </param>
        /// <returns> A new <see cref="Face.LivenessSessionItem"/> instance for mocking. </returns>
        public static LivenessSessionItem LivenessSessionItem(string id = null, DateTimeOffset createdDateTime = default, DateTimeOffset? sessionStartDateTime = null, bool sessionExpired = default, string deviceCorrelationId = null, int? authTokenTimeToLiveInSeconds = null)
        {
            return new LivenessSessionItem(
                id,
                createdDateTime,
                sessionStartDateTime,
                sessionExpired,
                deviceCorrelationId,
                authTokenTimeToLiveInSeconds,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.CreateLivenessWithVerifySessionContent"/>. </summary>
        /// <param name="livenessOperationMode"> Type of liveness mode the client should follow. </param>
        /// <param name="sendResultsToClient"> Whether or not to allow a '200 - Success' response body to be sent to the client, which may be undesirable for security reasons. Default is false, clients will receive a '204 - NoContent' empty body response. Regardless of selection, calling Session GetResult will always contain a response body enabling business logic to be implemented. </param>
        /// <param name="deviceCorrelationIdSetInClient"> Whether or not to allow client to set their own 'deviceCorrelationId' via the Vision SDK. Default is false, and 'deviceCorrelationId' must be set in this request body. </param>
        /// <param name="enableSessionImage"> Whether or not store the session image. </param>
        /// <param name="livenessSingleModalModel"> The model version used for liveness classification. This is an optional parameter, and if this is not specified, then the latest supported model version will be chosen. </param>
        /// <param name="deviceCorrelationId"> Unique Guid per each end-user device. This is to provide rate limiting and anti-hammering. If 'deviceCorrelationIdSetInClient' is true in this request, this 'deviceCorrelationId' must be null. </param>
        /// <param name="authTokenTimeToLiveInSeconds"> Seconds the session should last for. Range is 60 to 86400 seconds. Default value is 600. </param>
        /// <param name="returnVerifyImageHash"> Whether or not return the verify image hash. </param>
        /// <param name="verifyConfidenceThreshold"> Threshold for confidence of the face verification. </param>
        /// <returns> A new <see cref="Face.CreateLivenessWithVerifySessionContent"/> instance for mocking. </returns>
        public static CreateLivenessWithVerifySessionContent CreateLivenessWithVerifySessionContent(LivenessOperationMode livenessOperationMode = default, bool? sendResultsToClient = null, bool? deviceCorrelationIdSetInClient = null, bool? enableSessionImage = null, LivenessModel? livenessSingleModalModel = null, string deviceCorrelationId = null, int? authTokenTimeToLiveInSeconds = null, bool? returnVerifyImageHash = null, float? verifyConfidenceThreshold = null)
        {
            return new CreateLivenessWithVerifySessionContent(
                livenessOperationMode,
                sendResultsToClient,
                deviceCorrelationIdSetInClient,
                enableSessionImage,
                livenessSingleModalModel,
                deviceCorrelationId,
                authTokenTimeToLiveInSeconds,
                returnVerifyImageHash,
                verifyConfidenceThreshold,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.CreateLivenessWithVerifySessionResult"/>. </summary>
        /// <param name="sessionId"> The unique session ID of the created session. It will expire 48 hours after it was created or may be deleted sooner using the corresponding Session DELETE operation. </param>
        /// <param name="authToken"> Bearer token to provide authentication for the Vision SDK running on a client application. This Bearer token has limited permissions to perform only the required action and expires after the TTL time. It is also auditable. </param>
        /// <param name="verifyImage"> The detail of face for verification. </param>
        /// <returns> A new <see cref="Face.CreateLivenessWithVerifySessionResult"/> instance for mocking. </returns>
        public static CreateLivenessWithVerifySessionResult CreateLivenessWithVerifySessionResult(string sessionId = null, string authToken = null, LivenessWithVerifyImage verifyImage = null)
        {
            return new CreateLivenessWithVerifySessionResult(sessionId, authToken, verifyImage, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Face.LivenessWithVerifySession"/>. </summary>
        /// <param name="id"> The unique ID to reference this session. </param>
        /// <param name="createdDateTime"> DateTime when this session was created. </param>
        /// <param name="sessionStartDateTime"> DateTime when this session was started by the client. </param>
        /// <param name="sessionExpired"> Whether or not the session is expired. </param>
        /// <param name="deviceCorrelationId"> Unique Guid per each end-user device. This is to provide rate limiting and anti-hammering. If 'deviceCorrelationIdSetInClient' is true in this request, this 'deviceCorrelationId' must be null. </param>
        /// <param name="authTokenTimeToLiveInSeconds"> Seconds the session should last for. Range is 60 to 86400 seconds. Default value is 600. </param>
        /// <param name="status"> The current status of the session. </param>
        /// <param name="result"> The latest session audit result only populated if status == 'ResultAvailable'. </param>
        /// <returns> A new <see cref="Face.LivenessWithVerifySession"/> instance for mocking. </returns>
        public static LivenessWithVerifySession LivenessWithVerifySession(string id = null, DateTimeOffset createdDateTime = default, DateTimeOffset? sessionStartDateTime = null, bool sessionExpired = default, string deviceCorrelationId = null, int? authTokenTimeToLiveInSeconds = null, FaceSessionStatus status = default, LivenessSessionAuditEntry result = null)
        {
            return new LivenessWithVerifySession(
                id,
                createdDateTime,
                sessionStartDateTime,
                sessionExpired,
                deviceCorrelationId,
                authTokenTimeToLiveInSeconds,
                status,
                result,
                serializedAdditionalRawData: null);
        }
    }
}
