// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure;
using Azure.AI.Vision.Face;
using Azure.Core.Extensions;

namespace Microsoft.Extensions.Azure
{
    /// <summary> Extension methods to add <see cref="FaceAdministrationClient"/>, <see cref="FaceClient"/>, <see cref="FaceSessionClient"/> to client builder. </summary>
    public static partial class AIVisionFaceClientBuilderExtensions
    {
        /// <summary> Registers a <see cref="FaceAdministrationClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint">
        /// Supported Cognitive Services endpoints (protocol and hostname, for example:
        /// https://{resource-name}.cognitiveservices.azure.com).
        /// </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        public static IAzureClientBuilder<FaceAdministrationClient, AzureAIVisionFaceClientOptions> AddFaceAdministrationClient<TBuilder>(this TBuilder builder, Uri endpoint, AzureKeyCredential credential)
        where TBuilder : IAzureClientFactoryBuilder
        {
            return builder.RegisterClientFactory<FaceAdministrationClient, AzureAIVisionFaceClientOptions>((options) => new FaceAdministrationClient(endpoint, credential, options));
        }

        /// <summary> Registers a <see cref="FaceAdministrationClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint">
        /// Supported Cognitive Services endpoints (protocol and hostname, for example:
        /// https://{resource-name}.cognitiveservices.azure.com).
        /// </param>
        public static IAzureClientBuilder<FaceAdministrationClient, AzureAIVisionFaceClientOptions> AddFaceAdministrationClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<FaceAdministrationClient, AzureAIVisionFaceClientOptions>((options, cred) => new FaceAdministrationClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="FaceClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint">
        /// Supported Cognitive Services endpoints (protocol and hostname, for example:
        /// https://{resource-name}.cognitiveservices.azure.com).
        /// </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        public static IAzureClientBuilder<FaceClient, AzureAIVisionFaceClientOptions> AddFaceClient<TBuilder>(this TBuilder builder, Uri endpoint, AzureKeyCredential credential)
        where TBuilder : IAzureClientFactoryBuilder
        {
            return builder.RegisterClientFactory<FaceClient, AzureAIVisionFaceClientOptions>((options) => new FaceClient(endpoint, credential, options));
        }

        /// <summary> Registers a <see cref="FaceClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint">
        /// Supported Cognitive Services endpoints (protocol and hostname, for example:
        /// https://{resource-name}.cognitiveservices.azure.com).
        /// </param>
        public static IAzureClientBuilder<FaceClient, AzureAIVisionFaceClientOptions> AddFaceClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<FaceClient, AzureAIVisionFaceClientOptions>((options, cred) => new FaceClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="FaceSessionClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint">
        /// Supported Cognitive Services endpoints (protocol and hostname, for example:
        /// https://{resource-name}.cognitiveservices.azure.com).
        /// </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        public static IAzureClientBuilder<FaceSessionClient, AzureAIVisionFaceClientOptions> AddFaceSessionClient<TBuilder>(this TBuilder builder, Uri endpoint, AzureKeyCredential credential)
        where TBuilder : IAzureClientFactoryBuilder
        {
            return builder.RegisterClientFactory<FaceSessionClient, AzureAIVisionFaceClientOptions>((options) => new FaceSessionClient(endpoint, credential, options));
        }

        /// <summary> Registers a <see cref="FaceSessionClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint">
        /// Supported Cognitive Services endpoints (protocol and hostname, for example:
        /// https://{resource-name}.cognitiveservices.azure.com).
        /// </param>
        public static IAzureClientBuilder<FaceSessionClient, AzureAIVisionFaceClientOptions> AddFaceSessionClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<FaceSessionClient, AzureAIVisionFaceClientOptions>((options, cred) => new FaceSessionClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="FaceAdministrationClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<FaceAdministrationClient, AzureAIVisionFaceClientOptions> AddFaceAdministrationClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<FaceAdministrationClient, AzureAIVisionFaceClientOptions>(configuration);
        }
        /// <summary> Registers a <see cref="FaceClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<FaceClient, AzureAIVisionFaceClientOptions> AddFaceClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<FaceClient, AzureAIVisionFaceClientOptions>(configuration);
        }
        /// <summary> Registers a <see cref="FaceSessionClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<FaceSessionClient, AzureAIVisionFaceClientOptions> AddFaceSessionClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<FaceSessionClient, AzureAIVisionFaceClientOptions>(configuration);
        }
    }
}
