---
page_type: sample
languages:
- csharp
products:
- azure-face
name: Azure AI Vision Face samples for .NET
description: Samples for the Azure.AI.Vision.Face client library
---

# Azure Face client SDK Samples

Azure AI Vision Face is a cloud service that  gives you access to advanced algorithms that process images and return information based on the visual features you're interested in.

- Detect faces from image [synchronously](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/face/Azure.AI.Vision.Face/tests/samples/Sample1_FaceDetection.cs) or [asynchronously](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/face/Azure.AI.Vision.Face/tests/samples/Sample1_FaceDetectionAsync.cs)
  - From local image file
  - From URL
- Detect liveness in faces with session [synchronously](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/face/Azure.AI.Vision.Face/tests/samples/Sample2_DetectLivenessWithSession.cs) or [asynchronously](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/face/Azure.AI.Vision.Face/tests/samples/Sample2_DetectLivenessWithSessionAsync.cs)
- Detect liveness with face verification with session [synchronously](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/face/Azure.AI.Vision.Face/tests/samples/Sample3_DetectLivenessWithVerifyWithSession.cs) or [asynchronously](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/face/Azure.AI.Vision.Face/tests/samples/Sample3_DetectLivenessWithVerifyWithSessionAsync.cs)
- Stateless face recognition [synchronously](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/face/Azure.AI.Vision.Face/tests/samples/Sample4_StatelessFaceRecognition.cs) or [asynchronously](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/face/Azure.AI.Vision.Face/tests/samples/Sample4_StatelessFaceRecognitionAsync.cs)
- Verification and identification from Large Person Group [synchronously](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/face/Azure.AI.Vision.Face/tests/samples/Sample5_LargePersonGroup.cs) or [asynchronously](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/face/Azure.AI.Vision.Face/tests/samples/Sample5_LargePersonGroupAsync.cs)
- Find similar faces from a large face list [synchronously](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/face/Azure.AI.Vision.Face/tests/samples/Sample6_LargeFaceList.cs) or [asynchronously](https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/face/Azure.AI.Vision.Face/tests/samples/Sample6_LargeFaceListAsync.cs)
