// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Fabric.Models
{
    /// <summary> The updatable properties of the FabricCapacity. </summary>
    internal partial class FabricCapacityUpdateProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FabricCapacityUpdateProperties"/>. </summary>
        public FabricCapacityUpdateProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FabricCapacityUpdateProperties"/>. </summary>
        /// <param name="administration"> The capacity administration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FabricCapacityUpdateProperties(FabricCapacityAdministration administration, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Administration = administration;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The capacity administration. </summary>
        internal FabricCapacityAdministration Administration { get; set; }
        /// <summary> An array of administrator user identities. </summary>
        public IList<string> AdministrationMembers
        {
            get => Administration is null ? default : Administration.Members;
            set => Administration = new FabricCapacityAdministration(value);
        }
    }
}
