// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Fabric
{
    internal class FabricCapacityOperationSource : IOperationSource<FabricCapacityResource>
    {
        private readonly ArmClient _client;

        internal FabricCapacityOperationSource(ArmClient client)
        {
            _client = client;
        }

        FabricCapacityResource IOperationSource<FabricCapacityResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = FabricCapacityData.DeserializeFabricCapacityData(document.RootElement);
            return new FabricCapacityResource(_client, data);
        }

        async ValueTask<FabricCapacityResource> IOperationSource<FabricCapacityResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = FabricCapacityData.DeserializeFabricCapacityData(document.RootElement);
            return new FabricCapacityResource(_client, data);
        }
    }
}
