// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Fabric
{
    /// <summary>
    /// A class representing a collection of <see cref="FabricCapacityResource"/> and their operations.
    /// Each <see cref="FabricCapacityResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="FabricCapacityCollection"/> instance call the GetFabricCapacities method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class FabricCapacityCollection : ArmCollection, IEnumerable<FabricCapacityResource>, IAsyncEnumerable<FabricCapacityResource>
    {
        private readonly ClientDiagnostics _fabricCapacityClientDiagnostics;
        private readonly FabricCapacitiesRestOperations _fabricCapacityRestClient;

        /// <summary> Initializes a new instance of the <see cref="FabricCapacityCollection"/> class for mocking. </summary>
        protected FabricCapacityCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="FabricCapacityCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal FabricCapacityCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _fabricCapacityClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Fabric", FabricCapacityResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(FabricCapacityResource.ResourceType, out string fabricCapacityApiVersion);
            _fabricCapacityRestClient = new FabricCapacitiesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, fabricCapacityApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create a FabricCapacity
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric/capacities/{capacityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacity_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="capacityName"> The name of the Microsoft Fabric capacity. It must be a minimum of 3 characters, and a maximum of 63. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="capacityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="capacityName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<FabricCapacityResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string capacityName, FabricCapacityData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(capacityName, nameof(capacityName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _fabricCapacityClientDiagnostics.CreateScope("FabricCapacityCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _fabricCapacityRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, capacityName, data, cancellationToken).ConfigureAwait(false);
                var operation = new FabricArmOperation<FabricCapacityResource>(new FabricCapacityOperationSource(Client), _fabricCapacityClientDiagnostics, Pipeline, _fabricCapacityRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, capacityName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a FabricCapacity
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric/capacities/{capacityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacity_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="capacityName"> The name of the Microsoft Fabric capacity. It must be a minimum of 3 characters, and a maximum of 63. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="capacityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="capacityName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<FabricCapacityResource> CreateOrUpdate(WaitUntil waitUntil, string capacityName, FabricCapacityData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(capacityName, nameof(capacityName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _fabricCapacityClientDiagnostics.CreateScope("FabricCapacityCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _fabricCapacityRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, capacityName, data, cancellationToken);
                var operation = new FabricArmOperation<FabricCapacityResource>(new FabricCapacityOperationSource(Client), _fabricCapacityClientDiagnostics, Pipeline, _fabricCapacityRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, capacityName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a FabricCapacity
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric/capacities/{capacityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacity_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="capacityName"> The name of the Microsoft Fabric capacity. It must be a minimum of 3 characters, and a maximum of 63. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="capacityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="capacityName"/> is null. </exception>
        public virtual async Task<Response<FabricCapacityResource>> GetAsync(string capacityName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(capacityName, nameof(capacityName));

            using var scope = _fabricCapacityClientDiagnostics.CreateScope("FabricCapacityCollection.Get");
            scope.Start();
            try
            {
                var response = await _fabricCapacityRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, capacityName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new FabricCapacityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a FabricCapacity
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric/capacities/{capacityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacity_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="capacityName"> The name of the Microsoft Fabric capacity. It must be a minimum of 3 characters, and a maximum of 63. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="capacityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="capacityName"/> is null. </exception>
        public virtual Response<FabricCapacityResource> Get(string capacityName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(capacityName, nameof(capacityName));

            using var scope = _fabricCapacityClientDiagnostics.CreateScope("FabricCapacityCollection.Get");
            scope.Start();
            try
            {
                var response = _fabricCapacityRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, capacityName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new FabricCapacityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List FabricCapacity resources by resource group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric/capacities</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacity_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="FabricCapacityResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<FabricCapacityResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _fabricCapacityRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _fabricCapacityRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new FabricCapacityResource(Client, FabricCapacityData.DeserializeFabricCapacityData(e)), _fabricCapacityClientDiagnostics, Pipeline, "FabricCapacityCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List FabricCapacity resources by resource group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric/capacities</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacity_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="FabricCapacityResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<FabricCapacityResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _fabricCapacityRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _fabricCapacityRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new FabricCapacityResource(Client, FabricCapacityData.DeserializeFabricCapacityData(e)), _fabricCapacityClientDiagnostics, Pipeline, "FabricCapacityCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric/capacities/{capacityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacity_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="capacityName"> The name of the Microsoft Fabric capacity. It must be a minimum of 3 characters, and a maximum of 63. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="capacityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="capacityName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string capacityName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(capacityName, nameof(capacityName));

            using var scope = _fabricCapacityClientDiagnostics.CreateScope("FabricCapacityCollection.Exists");
            scope.Start();
            try
            {
                var response = await _fabricCapacityRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, capacityName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric/capacities/{capacityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacity_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="capacityName"> The name of the Microsoft Fabric capacity. It must be a minimum of 3 characters, and a maximum of 63. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="capacityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="capacityName"/> is null. </exception>
        public virtual Response<bool> Exists(string capacityName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(capacityName, nameof(capacityName));

            using var scope = _fabricCapacityClientDiagnostics.CreateScope("FabricCapacityCollection.Exists");
            scope.Start();
            try
            {
                var response = _fabricCapacityRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, capacityName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric/capacities/{capacityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacity_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="capacityName"> The name of the Microsoft Fabric capacity. It must be a minimum of 3 characters, and a maximum of 63. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="capacityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="capacityName"/> is null. </exception>
        public virtual async Task<NullableResponse<FabricCapacityResource>> GetIfExistsAsync(string capacityName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(capacityName, nameof(capacityName));

            using var scope = _fabricCapacityClientDiagnostics.CreateScope("FabricCapacityCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _fabricCapacityRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, capacityName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<FabricCapacityResource>(response.GetRawResponse());
                return Response.FromValue(new FabricCapacityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric/capacities/{capacityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacity_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="capacityName"> The name of the Microsoft Fabric capacity. It must be a minimum of 3 characters, and a maximum of 63. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="capacityName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="capacityName"/> is null. </exception>
        public virtual NullableResponse<FabricCapacityResource> GetIfExists(string capacityName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(capacityName, nameof(capacityName));

            using var scope = _fabricCapacityClientDiagnostics.CreateScope("FabricCapacityCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _fabricCapacityRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, capacityName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<FabricCapacityResource>(response.GetRawResponse());
                return Response.FromValue(new FabricCapacityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<FabricCapacityResource> IEnumerable<FabricCapacityResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<FabricCapacityResource> IAsyncEnumerable<FabricCapacityResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
