// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Fabric.Models;

namespace Azure.ResourceManager.Fabric.Mocking
{
    /// <summary> A class to add extension methods to SubscriptionResource. </summary>
    public partial class MockableFabricSubscriptionResource : ArmResource
    {
        private ClientDiagnostics _fabricCapacityClientDiagnostics;
        private FabricCapacitiesRestOperations _fabricCapacityRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableFabricSubscriptionResource"/> class for mocking. </summary>
        protected MockableFabricSubscriptionResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableFabricSubscriptionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableFabricSubscriptionResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics FabricCapacityClientDiagnostics => _fabricCapacityClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.Fabric", FabricCapacityResource.ResourceType.Namespace, Diagnostics);
        private FabricCapacitiesRestOperations FabricCapacityRestClient => _fabricCapacityRestClient ??= new FabricCapacitiesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(FabricCapacityResource.ResourceType));

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// List FabricCapacity resources by subscription ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Fabric/capacities</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacity_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="FabricCapacityResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<FabricCapacityResource> GetFabricCapacitiesAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => FabricCapacityRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => FabricCapacityRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new FabricCapacityResource(Client, FabricCapacityData.DeserializeFabricCapacityData(e)), FabricCapacityClientDiagnostics, Pipeline, "MockableFabricSubscriptionResource.GetFabricCapacities", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List FabricCapacity resources by subscription ID
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Fabric/capacities</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacity_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="FabricCapacityResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<FabricCapacityResource> GetFabricCapacities(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => FabricCapacityRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => FabricCapacityRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new FabricCapacityResource(Client, FabricCapacityData.DeserializeFabricCapacityData(e)), FabricCapacityClientDiagnostics, Pipeline, "MockableFabricSubscriptionResource.GetFabricCapacities", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Implements local CheckNameAvailability operations
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Fabric/locations/{location}/checkNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacities_CheckFabricCapacityNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="content"> The CheckAvailability request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<Response<FabricNameAvailabilityResult>> CheckFabricCapacityNameAvailabilityAsync(AzureLocation location, FabricNameAvailabilityContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = FabricCapacityClientDiagnostics.CreateScope("MockableFabricSubscriptionResource.CheckFabricCapacityNameAvailability");
            scope.Start();
            try
            {
                var response = await FabricCapacityRestClient.CheckFabricCapacityNameAvailabilityAsync(Id.SubscriptionId, location, content, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Implements local CheckNameAvailability operations
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Fabric/locations/{location}/checkNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacities_CheckFabricCapacityNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="content"> The CheckAvailability request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual Response<FabricNameAvailabilityResult> CheckFabricCapacityNameAvailability(AzureLocation location, FabricNameAvailabilityContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = FabricCapacityClientDiagnostics.CreateScope("MockableFabricSubscriptionResource.CheckFabricCapacityNameAvailability");
            scope.Start();
            try
            {
                var response = FabricCapacityRestClient.CheckFabricCapacityNameAvailability(Id.SubscriptionId, location, content, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List eligible SKUs for Microsoft Fabric resource provider
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Fabric/skus</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacities_ListSkus</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="FabricSkuDetailsForNewCapacity"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<FabricSkuDetailsForNewCapacity> GetSkusFabricCapacitiesAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => FabricCapacityRestClient.CreateListSkusRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => FabricCapacityRestClient.CreateListSkusNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => FabricSkuDetailsForNewCapacity.DeserializeFabricSkuDetailsForNewCapacity(e), FabricCapacityClientDiagnostics, Pipeline, "MockableFabricSubscriptionResource.GetSkusFabricCapacities", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List eligible SKUs for Microsoft Fabric resource provider
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Fabric/skus</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacities_ListSkus</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="FabricSkuDetailsForNewCapacity"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<FabricSkuDetailsForNewCapacity> GetSkusFabricCapacities(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => FabricCapacityRestClient.CreateListSkusRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => FabricCapacityRestClient.CreateListSkusNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => FabricSkuDetailsForNewCapacity.DeserializeFabricSkuDetailsForNewCapacity(e), FabricCapacityClientDiagnostics, Pipeline, "MockableFabricSubscriptionResource.GetSkusFabricCapacities", "value", "nextLink", cancellationToken);
        }
    }
}
