// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Fabric.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableFabricResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableFabricResourceGroupResource"/> class for mocking. </summary>
        protected MockableFabricResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableFabricResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableFabricResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of FabricCapacityResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of FabricCapacityResources and their operations over a FabricCapacityResource. </returns>
        public virtual FabricCapacityCollection GetFabricCapacities()
        {
            return GetCachedClient(client => new FabricCapacityCollection(client, Id));
        }

        /// <summary>
        /// Get a FabricCapacity
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric/capacities/{capacityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacity_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="capacityName"> The name of the Microsoft Fabric capacity. It must be a minimum of 3 characters, and a maximum of 63. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="capacityName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="capacityName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<FabricCapacityResource>> GetFabricCapacityAsync(string capacityName, CancellationToken cancellationToken = default)
        {
            return await GetFabricCapacities().GetAsync(capacityName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a FabricCapacity
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Fabric/capacities/{capacityName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FabricCapacity_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="FabricCapacityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="capacityName"> The name of the Microsoft Fabric capacity. It must be a minimum of 3 characters, and a maximum of 63. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="capacityName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="capacityName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<FabricCapacityResource> GetFabricCapacity(string capacityName, CancellationToken cancellationToken = default)
        {
            return GetFabricCapacities().Get(capacityName, cancellationToken);
        }
    }
}
