// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Fabric.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableFabricArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableFabricArmClient"/> class for mocking. </summary>
        protected MockableFabricArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableFabricArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableFabricArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableFabricArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="FabricCapacityResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="FabricCapacityResource.CreateResourceIdentifier" /> to create a <see cref="FabricCapacityResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="FabricCapacityResource"/> object. </returns>
        public virtual FabricCapacityResource GetFabricCapacityResource(ResourceIdentifier id)
        {
            FabricCapacityResource.ValidateResourceId(id);
            return new FabricCapacityResource(Client, id);
        }
    }
}
