// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Fabric.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmFabricModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Fabric.FabricCapacityData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <param name="sku"> The SKU details. </param>
        /// <returns> A new <see cref="Fabric.FabricCapacityData"/> instance for mocking. </returns>
        public static FabricCapacityData FabricCapacityData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, FabricCapacityProperties properties = null, FabricSku sku = null)
        {
            tags ??= new Dictionary<string, string>();

            return new FabricCapacityData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                sku,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FabricCapacityProperties"/>. </summary>
        /// <param name="provisioningState"> The current deployment state of Microsoft Fabric resource. The provisioningState is to indicate states for resource provisioning. </param>
        /// <param name="state"> The current state of Microsoft Fabric resource. The state is to indicate more states outside of resource provisioning. </param>
        /// <param name="administrationMembers"> The capacity administration. </param>
        /// <returns> A new <see cref="Models.FabricCapacityProperties"/> instance for mocking. </returns>
        public static FabricCapacityProperties FabricCapacityProperties(FabricProvisioningState? provisioningState = null, FabricResourceState? state = null, IEnumerable<string> administrationMembers = null)
        {
            administrationMembers ??= new List<string>();

            return new FabricCapacityProperties(provisioningState, state, administrationMembers != null ? new FabricCapacityAdministration(administrationMembers?.ToList(), serializedAdditionalRawData: null) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FabricNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> Indicates if the resource name is available. </param>
        /// <param name="reason"> The reason why the given name is not available. </param>
        /// <param name="message"> Detailed reason why the given name is not available. </param>
        /// <returns> A new <see cref="Models.FabricNameAvailabilityResult"/> instance for mocking. </returns>
        public static FabricNameAvailabilityResult FabricNameAvailabilityResult(bool? isNameAvailable = null, FabricNameUnavailableReason? reason = null, string message = null)
        {
            return new FabricNameAvailabilityResult(isNameAvailable, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FabricSkuDetailsForExistingCapacity"/>. </summary>
        /// <param name="resourceType"> The resource type. </param>
        /// <param name="sku"> The SKU details. </param>
        /// <returns> A new <see cref="Models.FabricSkuDetailsForExistingCapacity"/> instance for mocking. </returns>
        public static FabricSkuDetailsForExistingCapacity FabricSkuDetailsForExistingCapacity(string resourceType = null, FabricSku sku = null)
        {
            return new FabricSkuDetailsForExistingCapacity(resourceType, sku, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FabricSkuDetailsForNewCapacity"/>. </summary>
        /// <param name="resourceType"> The resource type. </param>
        /// <param name="name"> The SKU's name. </param>
        /// <param name="locations"> The list of available locations for the SKU. </param>
        /// <returns> A new <see cref="Models.FabricSkuDetailsForNewCapacity"/> instance for mocking. </returns>
        public static FabricSkuDetailsForNewCapacity FabricSkuDetailsForNewCapacity(string resourceType = null, string name = null, IEnumerable<AzureLocation> locations = null)
        {
            locations ??= new List<AzureLocation>();

            return new FabricSkuDetailsForNewCapacity(resourceType, name, locations?.ToList(), serializedAdditionalRawData: null);
        }
    }
}
