// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Fabric.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Fabric.Samples
{
    public partial class Sample_FabricCapacityResource
    {
        // Get a capacity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetACapacity()
        {
            // Generated from example definition: 2023-11-01/FabricCapacities_Get.json
            // this example is just showing the usage of "FabricCapacity_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FabricCapacityResource created on azure
            // for more information of creating FabricCapacityResource, please refer to the document of FabricCapacityResource
            string subscriptionId = "548B7FB7-3B2A-4F46-BB02-66473F1FC22C";
            string resourceGroupName = "TestRG";
            string capacityName = "azsdktest";
            ResourceIdentifier fabricCapacityResourceId = FabricCapacityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, capacityName);
            FabricCapacityResource fabricCapacity = client.GetFabricCapacityResource(fabricCapacityResourceId);

            // invoke the operation
            FabricCapacityResource result = await fabricCapacity.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FabricCapacityData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update capacity properties
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateCapacityProperties()
        {
            // Generated from example definition: 2023-11-01/FabricCapacities_Update.json
            // this example is just showing the usage of "FabricCapacity_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FabricCapacityResource created on azure
            // for more information of creating FabricCapacityResource, please refer to the document of FabricCapacityResource
            string subscriptionId = "548B7FB7-3B2A-4F46-BB02-66473F1FC22C";
            string resourceGroupName = "TestRG";
            string capacityName = "azsdktest";
            ResourceIdentifier fabricCapacityResourceId = FabricCapacityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, capacityName);
            FabricCapacityResource fabricCapacity = client.GetFabricCapacityResource(fabricCapacityResourceId);

            // invoke the operation
            FabricCapacityPatch patch = new FabricCapacityPatch()
            {
                Sku = new FabricSku("F8", FabricSkuTier.Fabric),
                Tags =
{
["testKey"] = "testValue",
},
                AdministrationMembers =
{
"azsdktest2@microsoft.com"
},
            };
            ArmOperation<FabricCapacityResource> lro = await fabricCapacity.UpdateAsync(WaitUntil.Completed, patch);
            FabricCapacityResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            FabricCapacityData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a capacity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteACapacity()
        {
            // Generated from example definition: 2023-11-01/FabricCapacities_Delete.json
            // this example is just showing the usage of "FabricCapacity_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FabricCapacityResource created on azure
            // for more information of creating FabricCapacityResource, please refer to the document of FabricCapacityResource
            string subscriptionId = "548B7FB7-3B2A-4F46-BB02-66473F1FC22C";
            string resourceGroupName = "TestRG";
            string capacityName = "azsdktest";
            ResourceIdentifier fabricCapacityResourceId = FabricCapacityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, capacityName);
            FabricCapacityResource fabricCapacity = client.GetFabricCapacityResource(fabricCapacityResourceId);

            // invoke the operation
            await fabricCapacity.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // List capacities by subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetFabricCapacities_ListCapacitiesBySubscription()
        {
            // Generated from example definition: 2023-11-01/FabricCapacities_ListBySubscription.json
            // this example is just showing the usage of "FabricCapacity_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "548B7FB7-3B2A-4F46-BB02-66473F1FC22C";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (FabricCapacityResource item in subscriptionResource.GetFabricCapacitiesAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                FabricCapacityData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Resume capacity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Resume_ResumeCapacity()
        {
            // Generated from example definition: 2023-11-01/FabricCapacities_Resume.json
            // this example is just showing the usage of "FabricCapacities_Resume" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FabricCapacityResource created on azure
            // for more information of creating FabricCapacityResource, please refer to the document of FabricCapacityResource
            string subscriptionId = "548B7FB7-3B2A-4F46-BB02-66473F1FC22C";
            string resourceGroupName = "TestRG";
            string capacityName = "azsdktest";
            ResourceIdentifier fabricCapacityResourceId = FabricCapacityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, capacityName);
            FabricCapacityResource fabricCapacity = client.GetFabricCapacityResource(fabricCapacityResourceId);

            // invoke the operation
            await fabricCapacity.ResumeAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Suspend capacity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Suspend_SuspendCapacity()
        {
            // Generated from example definition: 2023-11-01/FabricCapacities_Suspend.json
            // this example is just showing the usage of "FabricCapacities_Suspend" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FabricCapacityResource created on azure
            // for more information of creating FabricCapacityResource, please refer to the document of FabricCapacityResource
            string subscriptionId = "548B7FB7-3B2A-4F46-BB02-66473F1FC22C";
            string resourceGroupName = "TestRG";
            string capacityName = "azsdktest";
            ResourceIdentifier fabricCapacityResourceId = FabricCapacityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, capacityName);
            FabricCapacityResource fabricCapacity = client.GetFabricCapacityResource(fabricCapacityResourceId);

            // invoke the operation
            await fabricCapacity.SuspendAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Check name availability of a capacity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckFabricCapacityNameAvailability_CheckNameAvailabilityOfACapacity()
        {
            // Generated from example definition: 2023-11-01/FabricCapacities_CheckNameAvailability.json
            // this example is just showing the usage of "FabricCapacities_CheckFabricCapacityNameAvailability" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "548B7FB7-3B2A-4F46-BB02-66473F1FC22C";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            AzureLocation location = new AzureLocation("westcentralus");
            FabricNameAvailabilityContent content = new FabricNameAvailabilityContent()
            {
                Name = "azsdktest",
                ResourceType = "Microsoft.Fabric/capacities",
            };
            FabricNameAvailabilityResult result = await subscriptionResource.CheckFabricCapacityNameAvailabilityAsync(location, content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // List eligible SKUs for an existing capacity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSkusForCapacity_ListEligibleSKUsForAnExistingCapacity()
        {
            // Generated from example definition: 2023-11-01/FabricCapacities_ListSkusForCapacity.json
            // this example is just showing the usage of "FabricCapacities_ListSkusForCapacity" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this FabricCapacityResource created on azure
            // for more information of creating FabricCapacityResource, please refer to the document of FabricCapacityResource
            string subscriptionId = "548B7FB7-3B2A-4F46-BB02-66473F1FC22C";
            string resourceGroupName = "TestRG";
            string capacityName = "azsdktest";
            ResourceIdentifier fabricCapacityResourceId = FabricCapacityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, capacityName);
            FabricCapacityResource fabricCapacity = client.GetFabricCapacityResource(fabricCapacityResourceId);

            // invoke the operation and iterate over the result
            await foreach (FabricSkuDetailsForExistingCapacity item in fabricCapacity.GetSkusForCapacityAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // List eligible SKUs for a new capacity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSkusFabricCapacities_ListEligibleSKUsForANewCapacity()
        {
            // Generated from example definition: 2023-11-01/FabricCapacities_ListSkus.json
            // this example is just showing the usage of "FabricCapacities_ListSkus" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "548B7FB7-3B2A-4F46-BB02-66473F1FC22C";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (FabricSkuDetailsForNewCapacity item in subscriptionResource.GetSkusFabricCapacitiesAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
