# Azure Extensions libraries for .NET

Azure Extensions is a set of integration libraries for ASP.NET Core and Microsoft.Extensions packages.

- [Azure.Extensions.AspNetCore.Configuration.Secrets][configuration_secrets] allows Azure Key Vault Secrets to be used as a provider for Microsoft.Extensions.Configuration.

- [Azure.Extensions.AspNetCore.DataProtection.Keys][dataprotection_keys] allows Azure DataProtection Keys to be used as key protector for Microsoft.AspNetCore.DataProtection.

- [Azure.Extensions.AspNetCore.DataProtection.Blobs][dataprotection_blobs] allows Azure Storage Blob to be used as key store for Microsoft.AspNetCore.DataProtection.

## Contributing

This project welcomes contributions and suggestions.  Most contributions require
you to agree to a Contributor License Agreement (CLA) declaring that you have
the right to, and actually do, grant us the rights to use your contribution. For
details, visit [cla.microsoft.com][cla].

This project has adopted the [Microsoft Open Source Code of Conduct][coc].
For more information see the [Code of Conduct FAQ][coc_faq]
or contact [opencode@microsoft.com][coc_contact] with any
additional questions or comments.

![Impressions](https://azure-sdk-impressions.azurewebsites.net/api/impressions/azure-sdk-for-net%2Fsdk%2Fstorage%2FREADME.png)

<!-- LINKS -->
[configuration_secrets]: https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/extensions/Azure.Extensions.AspNetCore.Configuration.Secrets/README.md
[dataprotection_keys]: https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/extensions/Azure.Extensions.AspNetCore.DataProtection.Keys/README.md
[dataprotection_blobs]: https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/extensions/Azure.Extensions.AspNetCore.DataProtection.Blobs/README.md
[cla]: https://cla.microsoft.com
[coc]: https://opensource.microsoft.com/codeofconduct/
[coc_faq]: https://opensource.microsoft.com/codeofconduct/faq/
[coc_contact]: mailto:opencode@microsoft.com
