// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ExtendedLocations
{
    internal class CustomLocationOperationSource : IOperationSource<CustomLocationResource>
    {
        private readonly ArmClient _client;

        internal CustomLocationOperationSource(ArmClient client)
        {
            _client = client;
        }

        CustomLocationResource IOperationSource<CustomLocationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CustomLocationData.DeserializeCustomLocationData(document.RootElement);
            return new CustomLocationResource(_client, data);
        }

        async ValueTask<CustomLocationResource> IOperationSource<CustomLocationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CustomLocationData.DeserializeCustomLocationData(document.RootElement);
            return new CustomLocationResource(_client, data);
        }
    }
}
