// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.ExtendedLocations.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableExtendedLocationsArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableExtendedLocationsArmClient"/> class for mocking. </summary>
        protected MockableExtendedLocationsArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableExtendedLocationsArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableExtendedLocationsArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableExtendedLocationsArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="CustomLocationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="CustomLocationResource.CreateResourceIdentifier" /> to create a <see cref="CustomLocationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="CustomLocationResource"/> object. </returns>
        public virtual CustomLocationResource GetCustomLocationResource(ResourceIdentifier id)
        {
            CustomLocationResource.ValidateResourceId(id);
            return new CustomLocationResource(Client, id);
        }
    }
}
