// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.EventHubs.Models
{
    public partial class RetentionDescription : IUtf8JsonSerializable, IJsonModel<RetentionDescription>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RetentionDescription>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RetentionDescription>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RetentionDescription>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RetentionDescription)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(CleanupPolicy))
            {
                writer.WritePropertyName("cleanupPolicy"u8);
                writer.WriteStringValue(CleanupPolicy.Value.ToString());
            }
            if (Optional.IsDefined(RetentionTimeInHours))
            {
                writer.WritePropertyName("retentionTimeInHours"u8);
                writer.WriteNumberValue(RetentionTimeInHours.Value);
            }
            if (Optional.IsDefined(TombstoneRetentionTimeInHours))
            {
                writer.WritePropertyName("tombstoneRetentionTimeInHours"u8);
                writer.WriteNumberValue(TombstoneRetentionTimeInHours.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RetentionDescription IJsonModel<RetentionDescription>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RetentionDescription>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RetentionDescription)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRetentionDescription(document.RootElement, options);
        }

        internal static RetentionDescription DeserializeRetentionDescription(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            CleanupPolicyRetentionDescription? cleanupPolicy = default;
            long? retentionTimeInHours = default;
            int? tombstoneRetentionTimeInHours = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("cleanupPolicy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cleanupPolicy = new CleanupPolicyRetentionDescription(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("retentionTimeInHours"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    retentionTimeInHours = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("tombstoneRetentionTimeInHours"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    tombstoneRetentionTimeInHours = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RetentionDescription(cleanupPolicy, retentionTimeInHours, tombstoneRetentionTimeInHours, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CleanupPolicy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  cleanupPolicy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CleanupPolicy))
                {
                    builder.Append("  cleanupPolicy: ");
                    builder.AppendLine($"'{CleanupPolicy.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RetentionTimeInHours), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  retentionTimeInHours: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RetentionTimeInHours))
                {
                    builder.Append("  retentionTimeInHours: ");
                    builder.AppendLine($"'{RetentionTimeInHours.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TombstoneRetentionTimeInHours), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tombstoneRetentionTimeInHours: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TombstoneRetentionTimeInHours))
                {
                    builder.Append("  tombstoneRetentionTimeInHours: ");
                    builder.AppendLine($"{TombstoneRetentionTimeInHours.Value}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<RetentionDescription>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RetentionDescription>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(RetentionDescription)} does not support writing '{options.Format}' format.");
            }
        }

        RetentionDescription IPersistableModel<RetentionDescription>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RetentionDescription>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRetentionDescription(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RetentionDescription)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RetentionDescription>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
