// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventHubs.Models
{
    /// <summary> The EventHubsSchemaType. </summary>
    public readonly partial struct EventHubsSchemaType : IEquatable<EventHubsSchemaType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventHubsSchemaType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventHubsSchemaType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string AvroValue = "Avro";

        /// <summary> Unknown. </summary>
        public static EventHubsSchemaType Unknown { get; } = new EventHubsSchemaType(UnknownValue);
        /// <summary> Avro. </summary>
        public static EventHubsSchemaType Avro { get; } = new EventHubsSchemaType(AvroValue);
        /// <summary> Determines if two <see cref="EventHubsSchemaType"/> values are the same. </summary>
        public static bool operator ==(EventHubsSchemaType left, EventHubsSchemaType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventHubsSchemaType"/> values are not the same. </summary>
        public static bool operator !=(EventHubsSchemaType left, EventHubsSchemaType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventHubsSchemaType"/>. </summary>
        public static implicit operator EventHubsSchemaType(string value) => new EventHubsSchemaType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventHubsSchemaType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventHubsSchemaType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
