// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventHubs.Models
{
    /// <summary> This determines if traffic is allowed over public network. By default it is enabled. </summary>
    public readonly partial struct EventHubsPublicNetworkAccess : IEquatable<EventHubsPublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventHubsPublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventHubsPublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string SecuredByPerimeterValue = "SecuredByPerimeter";

        /// <summary> Enabled. </summary>
        public static EventHubsPublicNetworkAccess Enabled { get; } = new EventHubsPublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static EventHubsPublicNetworkAccess Disabled { get; } = new EventHubsPublicNetworkAccess(DisabledValue);
        /// <summary> SecuredByPerimeter. </summary>
        public static EventHubsPublicNetworkAccess SecuredByPerimeter { get; } = new EventHubsPublicNetworkAccess(SecuredByPerimeterValue);
        /// <summary> Determines if two <see cref="EventHubsPublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(EventHubsPublicNetworkAccess left, EventHubsPublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventHubsPublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(EventHubsPublicNetworkAccess left, EventHubsPublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventHubsPublicNetworkAccess"/>. </summary>
        public static implicit operator EventHubsPublicNetworkAccess(string value) => new EventHubsPublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventHubsPublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventHubsPublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
