// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventHubs.Models
{
    /// <summary> Provisioning state of the Private Endpoint Connection. </summary>
    public readonly partial struct EventHubsPrivateEndpointConnectionProvisioningState : IEquatable<EventHubsPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventHubsPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventHubsPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";

        /// <summary> Creating. </summary>
        public static EventHubsPrivateEndpointConnectionProvisioningState Creating { get; } = new EventHubsPrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static EventHubsPrivateEndpointConnectionProvisioningState Updating { get; } = new EventHubsPrivateEndpointConnectionProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static EventHubsPrivateEndpointConnectionProvisioningState Deleting { get; } = new EventHubsPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static EventHubsPrivateEndpointConnectionProvisioningState Succeeded { get; } = new EventHubsPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static EventHubsPrivateEndpointConnectionProvisioningState Canceled { get; } = new EventHubsPrivateEndpointConnectionProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static EventHubsPrivateEndpointConnectionProvisioningState Failed { get; } = new EventHubsPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="EventHubsPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(EventHubsPrivateEndpointConnectionProvisioningState left, EventHubsPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventHubsPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(EventHubsPrivateEndpointConnectionProvisioningState left, EventHubsPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventHubsPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator EventHubsPrivateEndpointConnectionProvisioningState(string value) => new EventHubsPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventHubsPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventHubsPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
