// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EventHubs.Models
{
    /// <summary> Direction of Access Rule. </summary>
    public readonly partial struct EventHubsNspAccessRuleDirection : IEquatable<EventHubsNspAccessRuleDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventHubsNspAccessRuleDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventHubsNspAccessRuleDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InboundValue = "Inbound";
        private const string OutboundValue = "Outbound";

        /// <summary> Inbound. </summary>
        public static EventHubsNspAccessRuleDirection Inbound { get; } = new EventHubsNspAccessRuleDirection(InboundValue);
        /// <summary> Outbound. </summary>
        public static EventHubsNspAccessRuleDirection Outbound { get; } = new EventHubsNspAccessRuleDirection(OutboundValue);
        /// <summary> Determines if two <see cref="EventHubsNspAccessRuleDirection"/> values are the same. </summary>
        public static bool operator ==(EventHubsNspAccessRuleDirection left, EventHubsNspAccessRuleDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventHubsNspAccessRuleDirection"/> values are not the same. </summary>
        public static bool operator !=(EventHubsNspAccessRuleDirection left, EventHubsNspAccessRuleDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventHubsNspAccessRuleDirection"/>. </summary>
        public static implicit operator EventHubsNspAccessRuleDirection(string value) => new EventHubsNspAccessRuleDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventHubsNspAccessRuleDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventHubsNspAccessRuleDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
